package cn.lili.rocketmq.consumer;

import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.common.message.MessageExt;
import org.springframework.stereotype.Component;

import java.nio.charset.StandardCharsets;
import java.util.Objects;

/**
 * @Author yuquanfeng
 * @Date 2023/5/25
 * @Description
 * @Param
 * @return
 **/
@Component
@Slf4j
public class ConsumerMessageService {

    public void consumer(MessageExt messageExt) throws Exception {
        String topic = messageExt.getTopic();
        String tags = messageExt.getTags();
        String message = new String(messageExt.getBody(), StandardCharsets.UTF_8);
        log.info("ConsumerMessageService consumer topic:{}, tag:{}, message:{}", topic, tags, message);
        AbstractMessageHandler consumer = MessageHandlerInstanceHandler.getInstance(tags);
        if(Objects.isNull(consumer)){
            log.info("ConsumerMessageService consumer 没有找到对应的消费者 topic:{}, tag:{}, message:{}", topic, tags, message);
            return;
        }
        consumer.consumer(message, messageExt.getReconsumeTimes(), topic, tags);

    }

}
