package cn.lili.rocketmq.consumer.listner;

import cn.lili.rocketmq.consumer.AbstractMessageHandler;
import cn.lili.rocketmq.consumer.MessageHandlerInstanceHandler;
import cn.lili.rocketmq.consumer.annotation.TagSub;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @Author yuquanfeng
 * @Date 2023/5/25
 * @Description
 * @Param
 * @return
 **/
@Component
@Slf4j
public class InitRocketMqMessageHandlerListener implements ApplicationListener<ContextRefreshedEvent> {

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        Map<String, Object> beansWithAnnotation = event.getApplicationContext().getBeansWithAnnotation(TagSub.class);
        if(beansWithAnnotation != null && !beansWithAnnotation.isEmpty()){
            beansWithAnnotation.values().forEach(bean -> {
                if(bean instanceof AbstractMessageHandler){
                    TagSub declaredAnnotation = bean.getClass().getDeclaredAnnotation(TagSub.class);
                    String tag = declaredAnnotation.tag();
                    log.info("初始化 tag对应的handler tag:{}", tag);
                    MessageHandlerInstanceHandler.abstractMessageHandlerMap.put(tag, (AbstractMessageHandler) bean);
                }
            });
        }
    }
}
