/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.context.util.http;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseKit {
    private static final Logger log = LoggerFactory.getLogger(ResponseKit.class);

    public static void writeJSON(ServletResponse response, Object result) {
        try {
            String resultString = JSONObject.toJSONString((Object)result);
            response.setContentType("application/json;charset=utf-8");
            response.getWriter().write(resultString);
            response.getWriter().flush();
            response.getWriter().close();
        }
        catch (IOException e) {
            log.error("HttpServletResponse write error", (Throwable)e);
        }
    }

    public static void setCorsHeaderAndWriteJSON(HttpServletRequest request, HttpServletResponse response, Object result) {
        ResponseKit.setCorsHeader(request, response);
        ResponseKit.writeJSON((ServletResponse)response, result);
    }

    public static void setCorsHeader(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", request.getHeader("Origin"));
        response.setHeader("Access-Control-Allow-Methods", request.getHeader("Access-Control-Request-Method"));
        response.setHeader("Access-Control-Allow-Headers", request.getHeader("Access-Control-Request-Headers"));
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Max-Age", "86400");
    }
}

