/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.context.web.controller;

import cn.tuia.mango.context.service.BaseMybatisInternalService;
import cn.tuia.mango.core.domain.BaseDomain;
import cn.tuia.mango.core.domain.api.Result;
import cn.tuia.mango.core.domain.api.Results;
import cn.tuia.mango.core.domain.page.PageData;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public class BaseController<T extends BaseDomain, S extends BaseMybatisInternalService<?, T>> {
    @Autowired
    protected S service;

    public S getService() {
        return this.service;
    }

    @GetMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public Result<PageData<T>> page(T query, @RequestParam(defaultValue="1", value="current") Integer current, @RequestParam(defaultValue="10", value="size") Integer size) {
        query.setCurrentAndSize(current.intValue(), size.intValue());
        PageData<T> page = this.getService().page(query);
        return Results.success(page);
    }

    @GetMapping(value={"list"})
    @ApiOperation(value="\u5217\u8868\u67e5\u8be2\uff0c\u8fd4\u56deList")
    public Result<List<T>> list(T query, @RequestParam(defaultValue="1", value="current") Integer current, @RequestParam(defaultValue="10", value="size") Integer size) {
        query.setCurrentAndSize(current.intValue(), size.intValue());
        List<T> list = this.getService().list(query);
        return Results.success(list);
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u8be6\u60c5")
    public Result<T> get(@PathVariable(value="id") Long id) {
        Object domain = this.getService().getById(id);
        return Results.success(domain);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u4fdd\u5b58")
    public Result<Boolean> save(@RequestBody T domain) {
        boolean canSave = this.onSave(domain);
        if (!canSave) {
            return Results.forbidden();
        }
        int affected = this.getService().save(domain);
        return Results.success((Object)(affected > 0 ? 1 : 0));
    }

    protected boolean onSave(T domain) {
        return false;
    }
}

