package cn.tuia.mango.generator.mybatis.boot;

import cn.tuia.mango.generator.mybatis.api.GeneratorProcessCallback;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.api.ShellRunner;
import org.mybatis.generator.api.VerboseProgressCallback;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.xml.ConfigurationParser;
import org.mybatis.generator.internal.DefaultShellCallback;
import org.springframework.util.Assert;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * @author lijicong
 * @since 2020-03-19
 */
public class MyBatisGeneratorBoot {

    public static void run(String path) {
        Assert.hasText(path, "path must have text!");
        try {
            List<String> warnings = new ArrayList<>();
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            InputStream is = classloader.getResourceAsStream(path);
            ConfigurationParser cp = new ConfigurationParser(warnings);
            Configuration config = cp.parseConfiguration(is);
            DefaultShellCallback callback = new DefaultShellCallback(true);
            MyBatisGenerator myBatisGenerator = new MyBatisGenerator(config, callback, warnings);
            GeneratorProcessCallback progressCallback = new GeneratorProcessCallback(warnings);
            myBatisGenerator.generate(progressCallback);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public static void shellRun(String path) {
        Assert.hasText(path, "path must have text!");
        String config = Thread.currentThread().getContextClassLoader().getResource(path).getFile();
        String[] arg = {"-configfile", config, "-overwrite"};
        ShellRunner.main(arg);
    }

}
