package cn.tuia.mango.generator.mybatis.codegen.mybatis3.model;

import cn.tuia.mango.generator.mybatis.util.StringUtils;
import lombok.Getter;
import lombok.Setter;
import org.mybatis.generator.api.IntrospectedColumn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

/**
 * @author lijicong
 * @since 2020-04-06
 */
@Getter
@Setter
public class JavaEnumConfig {

    private String serviceTargetPackage;

    private String targetPackage;
    private String targetProject;
    private String module;
    private String enumPackage;

    private boolean enableEnum;
    private Map<String, IntrospectedColumn> columnCommentMap = new HashMap<>();
    private List<EnumConfig> enums;

    public IntrospectedColumn putIfAbsent(String key, IntrospectedColumn value) {
        return columnCommentMap.putIfAbsent(key, value);
    }

    public void init() {
        if (this.serviceTargetPackage == null) {
            return;
        }
        String[] packages = this.serviceTargetPackage.split("\\.");
        this.module = packages[packages.length - 1];
        enums = new ArrayList<>();
        for (Entry<String, IntrospectedColumn> entry : columnCommentMap.entrySet()) {
            IntrospectedColumn column = entry.getValue();
            String remarks = column.getRemarks();
            EnumConfig enumConfig = new EnumConfig();
            enumConfig.setClassName(StringUtils.capitalize(entry.getKey()) + "Enum");
            enumConfig.setRemarks(remarks);
            enumConfig.setJavaType(column.getFullyQualifiedJavaType().getShortName());
            try {
                String[] s = remarks.split(" ");
                List<EnumItemConfig> itemList = new ArrayList<>();
                for (int i = 1; i < s.length; i++) {
                    String[] item = s[i].split(":");
                    EnumItemConfig itemConfig = new EnumItemConfig();
                    itemConfig.setText(column.getActualColumnName().toUpperCase() + "_" + item[0]);
                    itemConfig.setCode(item[0]);
                    itemConfig.setDesc(item[1]);
                    itemList.add(itemConfig);
                }
                enumConfig.setItemList(itemList);
                enums.add(enumConfig);
            } catch (Exception e) {
                System.err.println("表[" + column.getIntrospectedTable().getFullyQualifiedTableNameAtRuntime() +
                        "], 字段[" + column.getActualColumnName() +
                        "], 注释[" + column.getRemarks() +
                        "], 不符合规范[remark code1:value1 code2:value2], 不能生成枚举");
            }
        }

    }

    @Setter
    @Getter
    public static class EnumConfig {
        private String className;
        private String remarks;
        private String javaType;
        private List<EnumItemConfig> itemList;
    }

    @Setter
    @Getter
    public static class EnumItemConfig {
        private String text;
        private String code;
        private String desc;
    }

}
