package cn.tuia.mango.generator.mybatis.internal;

import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.util.StringUtility;

/**
 * 使用swagger注解
 * @author lijicong
 * @since 2020-03-31
 */
public class SwaggerCommentGenerator extends JavaCommentGenerator {


    @Override
    public void addModelClassComment(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        super.addModelClassComment(topLevelClass, introspectedTable);
        topLevelClass.addImportedType("io.swagger.annotations.ApiModelProperty");
    }

    @Override
    public void addFieldComment(Field field, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        String remarks = introspectedColumn.getRemarks();
        if (StringUtility.stringHasValue(remarks)) {
            field.addAnnotation("@ApiModelProperty(value = \"" + remarks + "\")");
        }

    }
}
