package cn.tuia.mango.generator.mybatis.plugin;

import cn.tuia.mango.generator.mybatis.api.GeneratedTemplateFile;
import cn.tuia.mango.generator.mybatis.api.TemplateGenerator;
import cn.tuia.mango.generator.mybatis.codegen.ExtensionConstants;
import cn.tuia.mango.generator.mybatis.config.PropertyRegistryExtension;
import cn.tuia.mango.generator.mybatis.util.FreeMarkerUtils;
import cn.tuia.mango.generator.mybatis.util.GeneratorUtils;
import cn.tuia.mango.generator.mybatis.util.JavaModelUtils;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModelException;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.internal.util.StringUtility;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author lijicong
 * @since 2020-03-20
 */
public abstract class AbstractTemplatePlugin extends PluginAdapter {

    public static final String TEMPLATE_PATH = "template/";

    protected TemplateGenerator templateGenerator = TemplateGenerator.getInstance();
    protected static TemplateHashModel staticModels;

    protected Map<String, GeneratedTemplateFile> configMap = new ConcurrentHashMap<>();
    protected Map<String, Object> templateDataMap = new ConcurrentHashMap<>();

    public static final String TEMPLATE_DATA_MAP_CONFIG_KEY = "config";
    public static final String TEMPLATE_DATA_MAP_CONFIG_ALL_KEY = "configAll";

    protected boolean overwrite;
    protected String targetPackage;
    protected String targetProject;

    static {
        BeansWrapperBuilder builder = new BeansWrapperBuilder(Configuration.VERSION_2_3_21);
        builder.setUseModelCache(true);
        builder.setExposeFields(true);
        BeansWrapper beansWrapper = builder.build();
        staticModels = beansWrapper.getStaticModels();
    }

    @Override
    public boolean validate(List<String> warnings) {
        if (StringUtility.isTrue(properties.getProperty(PropertyRegistryExtension.PLUGIN_OVERWRITE))) {
            overwrite = true;
        }
        String targetProject = properties.getProperty(PropertyRegistryExtension.PLUGIN_TARGET_PROJECT);
        if (StringUtility.stringHasValue(targetProject)) {
            this.targetProject = targetProject;
        }
        String targetPackage = properties.getProperty(PropertyRegistryExtension.PLUGIN_TARGET_PACKAGE);
        if (StringUtility.stringHasValue(targetPackage)) {
            this.targetPackage = targetPackage;
        }
        return true;
    }

    protected void registerConfigMap(String templateName, IntrospectedTable table) {
        table.setAttribute("templateName", templateName);
        GeneratedTemplateFile javaFileConfig = new GeneratedTemplateFile(targetProject, targetPackage, context, properties, table);
        configMap.put(templateName, javaFileConfig);
    }


    public void templateGenerate() {
        putStaticClass(JavaModelUtils.class);
        for (Map.Entry<String, GeneratedTemplateFile> entry : configMap.entrySet()) {
            String key = entry.getKey();
            GeneratedTemplateFile config = entry.getValue();
            if (overwrite || !GeneratorUtils.exists(config)) {
                templateDataMap.put(TEMPLATE_DATA_MAP_CONFIG_KEY, config);
                templateDataMap.put(ExtensionConstants.ORIGINAL_CLASS_NAME, config.getTable().getAttribute(ExtensionConstants.ORIGINAL_CLASS_NAME));
                templateDataMap.put("table", config.getTable());
                String content = FreeMarkerUtils.template(TEMPLATE_PATH, key + ".ftl", templateDataMap);
                config.setFormattedContent(content);
                templateGenerator.addGeneratedFile(config);
            }
        }
        templateGenerator.generate();
    }

    protected void putStaticClass(Class<?> clazz) {
        try {
            templateDataMap.put(clazz.getSimpleName(), staticModels.get(clazz.getName()));
        } catch (TemplateModelException e) {
            e.printStackTrace();
        }
    }
}
