package cn.tuia.mango.generator.mybatis.util;

import cn.tuia.mango.generator.mybatis.codegen.ExtensionConstants;
import cn.tuia.mango.generator.mybatis.plugin.JavaServicePlugin;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.PluginConfiguration;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

/**
 * @author lijicong
 * @since 2020-03-20
 */
public class JavaModelUtils {

    public static String getDomainSimpleName(IntrospectedTable introspectedTable) {
        String domainObjectName = introspectedTable.getFullyQualifiedTable().getDomainObjectName();
        if (domainObjectName.endsWith(ExtensionConstants.DOMAIN_DO_SUFFIX)) {
            domainObjectName = domainObjectName.substring(0, domainObjectName.length() - 2);
        }
        return domainObjectName;
    }

    public static Set<String> listImportColumns(List<IntrospectedColumn> introspectedColumns) {
        Set<String> importClass = new HashSet<>();
        for (IntrospectedColumn column : introspectedColumns) {
            String importJavaType = column.getFullyQualifiedJavaType().getFullyQualifiedNameWithoutTypeParameters();
            if (!importJavaType.startsWith("java.lang.") && !"byte[]".equals(importJavaType)) {
                importClass.add(column.getFullyQualifiedJavaType().getFullyQualifiedNameWithoutTypeParameters());
            }
        }
        return importClass;
    }

    @SuppressWarnings("unchecked")
    public static String getJavaServiceTargetPackage(Context context) {
        Field filed = ReflectionUtils.findField(Context.class, "pluginConfigurations");
        filed.setAccessible(true);
        List<PluginConfiguration> field = (List<PluginConfiguration>) ReflectionUtils.getField(filed, context);
        Optional<PluginConfiguration> optional = field.stream().filter(item -> item.getConfigurationType().equals(JavaServicePlugin.class.getName())).findAny();
        return optional.orElse(new PluginConfiguration()).getProperty("targetPackage");
    }
}
