/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.generator.mybatis.ant;

import cn.tuia.mango.generator.mybatis.api.AntGeneratorProgressCallback;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.PropertySet;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.api.ProgressCallback;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.xml.ConfigurationParser;
import org.mybatis.generator.exception.InvalidConfigurationException;
import org.mybatis.generator.exception.XMLParserException;
import org.mybatis.generator.internal.DefaultShellCallback;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

public class GeneratorAntTask
extends Task {
    private String configfile;
    private boolean overwrite;
    private PropertySet propertyset;
    private boolean verbose;
    private String contextIds;
    private String fullyQualifiedTableNames;

    public void execute() throws BuildException {
        if (!StringUtility.stringHasValue((String)this.configfile)) {
            throw new BuildException(Messages.getString((String)"RuntimeError.0"));
        }
        ArrayList warnings = new ArrayList();
        File configurationFile = new File(this.configfile);
        if (!configurationFile.exists()) {
            throw new BuildException(Messages.getString((String)"RuntimeError.1", (String)this.configfile));
        }
        HashSet<String> fullyqualifiedTables = new HashSet<String>();
        if (StringUtility.stringHasValue((String)this.fullyQualifiedTableNames)) {
            StringTokenizer st = new StringTokenizer(this.fullyQualifiedTableNames, ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                if (s.length() <= 0) continue;
                fullyqualifiedTables.add(s);
            }
        }
        HashSet<String> contexts = new HashSet<String>();
        if (StringUtility.stringHasValue((String)this.contextIds)) {
            StringTokenizer st = new StringTokenizer(this.contextIds, ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                if (s.length() <= 0) continue;
                contexts.add(s);
            }
        }
        try {
            Properties p = this.propertyset == null ? null : this.propertyset.getProperties();
            ConfigurationParser cp = new ConfigurationParser(p, warnings);
            Configuration config = cp.parseConfiguration(configurationFile);
            DefaultShellCallback callback = new DefaultShellCallback(this.overwrite);
            MyBatisGenerator myBatisGenerator = new MyBatisGenerator(config, (ShellCallback)callback, warnings);
            myBatisGenerator.generate((ProgressCallback)new AntGeneratorProgressCallback(this, this.verbose), contexts, fullyqualifiedTables);
        }
        catch (XMLParserException e) {
            for (String error : e.getErrors()) {
                this.log(error, 0);
            }
            throw new BuildException(e.getMessage());
        }
        catch (SQLException e) {
            throw new BuildException(e.getMessage());
        }
        catch (IOException e) {
            throw new BuildException(e.getMessage());
        }
        catch (InvalidConfigurationException e) {
            for (String error : e.getErrors()) {
                this.log(error, 0);
            }
            throw new BuildException(e.getMessage());
        }
        catch (InterruptedException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException(e.getMessage());
        }
        for (String error : warnings) {
            this.log(error, 1);
        }
    }

    public String getConfigfile() {
        return this.configfile;
    }

    public void setConfigfile(String configfile) {
        this.configfile = configfile;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public PropertySet createPropertyset() {
        if (this.propertyset == null) {
            this.propertyset = new PropertySet();
        }
        return this.propertyset;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getContextIds() {
        return this.contextIds;
    }

    public void setContextIds(String contextIds) {
        this.contextIds = contextIds;
    }

    public String getFullyQualifiedTableNames() {
        return this.fullyQualifiedTableNames;
    }

    public void setFullyQualifiedTableNames(String fullyQualifiedTableNames) {
        this.fullyQualifiedTableNames = fullyQualifiedTableNames;
    }
}

