/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.generator.mybatis.plugin;

import cn.tuia.mango.generator.mybatis.api.GeneratedTemplateFile;
import cn.tuia.mango.generator.mybatis.api.TemplateGenerator;
import cn.tuia.mango.generator.mybatis.util.FreeMarkerUtils;
import cn.tuia.mango.generator.mybatis.util.GeneratorUtils;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.TemplateHashModel;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.internal.util.StringUtility;

public abstract class AbstractTemplatePlugin
extends PluginAdapter {
    public static final String TEMPLATE_PATH = "template/";
    protected TemplateGenerator templateGenerator = TemplateGenerator.getInstance();
    protected static TemplateHashModel staticModels;
    protected Map<String, GeneratedTemplateFile> configMap = new ConcurrentHashMap<String, GeneratedTemplateFile>();
    protected Map<String, Object> templateDataMap = new ConcurrentHashMap<String, Object>();
    public static final String TEMPLATE_DATA_MAP_CONFIG_KEY = "config";
    public static final String TEMPLATE_DATA_MAP_CONFIG_ALL_KEY = "configAll";
    protected boolean overwrite;
    protected String targetPackage;
    protected String targetProject;

    public boolean validate(List<String> warnings) {
        String targetPackage;
        String targetProject;
        if (StringUtility.isTrue((String)this.properties.getProperty("overwrite"))) {
            this.overwrite = true;
        }
        if (StringUtility.stringHasValue((String)(targetProject = this.properties.getProperty("targetProject")))) {
            this.targetProject = targetProject;
        }
        if (StringUtility.stringHasValue((String)(targetPackage = this.properties.getProperty("targetPackage")))) {
            this.targetPackage = targetPackage;
        }
        return true;
    }

    protected void registerConfigMap(String templateName, IntrospectedTable table) {
        table.setAttribute("templateName", (Object)templateName);
        GeneratedTemplateFile javaFileConfig = new GeneratedTemplateFile(this.targetProject, this.targetPackage, this.context, this.properties, table);
        this.configMap.put(templateName, javaFileConfig);
    }

    public void templateGenerate() {
        for (Map.Entry<String, GeneratedTemplateFile> entry : this.configMap.entrySet()) {
            String key = entry.getKey();
            GeneratedTemplateFile config = entry.getValue();
            if (!this.overwrite && GeneratorUtils.exists(config)) continue;
            this.templateDataMap.put(TEMPLATE_DATA_MAP_CONFIG_KEY, (Object)config);
            this.templateDataMap.put("originalClassName", config.getTable().getAttribute("originalClassName"));
            this.templateDataMap.put("table", config.getTable());
            String content = FreeMarkerUtils.template(TEMPLATE_PATH, key + ".ftl", this.templateDataMap);
            config.setFormattedContent(content);
            this.templateGenerator.addGeneratedFile(config);
        }
        this.templateGenerator.generate();
    }

    static {
        BeansWrapperBuilder builder = new BeansWrapperBuilder(Configuration.VERSION_2_3_21);
        builder.setUseModelCache(true);
        builder.setExposeFields(true);
        BeansWrapper beansWrapper = builder.build();
        staticModels = beansWrapper.getStaticModels();
    }
}

