<#import "common.lib.java.ftl" as java>
package ${config.targetPackage};

import cn.tuia.mango.core.enums.CodeDescriptionEnumerable;
import cn.tuia.mango.core.util.EnumKit;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Optional;

public abstract class ${config.module?capitalize}Enums {

    <#list config.enums as property>
    <#if property.javaType == 'String'>
    // ${property.remarks}
    @Getter
    @AllArgsConstructor
    public enum ${property.className} implements CodeDescriptionEnumerable<String, String> {
        <#list property.itemList as item>
        ${item.text}("${item.code}", "${item.desc}"),
        </#list>
        ;

        private String code;
        private String description;

        public static Optional<${property.className}> of(String code) {
            return EnumKit.of(${property.className}.class, code);
        }
    }
    <#elseif property.javaType == 'Integer'>
    // ${property.remarks}
    @Getter
    @AllArgsConstructor
    public enum ${property.className} implements CodeDescriptionEnumerable<Integer, String> {
        <#list property.itemList as item>
        ${item.text}(${item.code}, "${item.desc}"),
        </#list>
        ;

        private Integer code;
        private String description;

        public static Optional<${property.className}> of(Integer code) {
            return EnumKit.of(${property.className}.class, code);
        }
    }
    </#if>

    </#list>
}