package cn.tuia.mango.generator.mybatis.plugin;

import cn.tuia.mango.generator.mybatis.api.GeneratedTemplateFile;
import cn.tuia.mango.generator.mybatis.codegen.ExtensionConstants;
import cn.tuia.mango.generator.mybatis.codegen.mybatis3.model.JavaEnumConfig;
import cn.tuia.mango.generator.mybatis.config.PropertyRegistryExtension;
import cn.tuia.mango.generator.mybatis.util.JavaModelUtils;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.util.StringUtility;

import java.util.List;

/**
 * 模板生成Service等其他业务类
 * @author lijicong
 * @since 2020-03-19
 */
public class JavaServicePlugin extends AbstractTemplatePlugin {

    // controller
    protected boolean enableController;
    protected String controllerTargetProject;
    protected String controllerTargetPackage;

    // enum
    protected boolean enableEnum;
    protected String enumTargetProject;
    protected String enumTargetPackage;

    // remote
    protected boolean enableRemoteService;
    protected boolean enableRemoteServiceMethods;
    protected String remoteServicetargetProject;
    protected String remoteServiceTargetPackage;
    protected String remoteServiceImplTargetPackage;
    protected String remoteQueryDTOTargetPackage;
    protected String remoteFormDTOTargetPackage;
    protected String remoteDTOTargetPackage;


    public static JavaEnumConfig javaEnumConfig = new JavaEnumConfig();

    @Override
    public boolean validate(List<String> warnings) {

        // controller
        if (StringUtility.isTrue(properties.getProperty(PropertyRegistryExtension.PLUGIN_ENABLE_CONTROLLER))) {
            enableController = true;
        }
        if (StringUtility.stringHasValue(properties.getProperty(PropertyRegistryExtension.PLUGIN_CONTROLLER_TARGET_PROJECT))) {
            controllerTargetProject = properties.getProperty(PropertyRegistryExtension.PLUGIN_CONTROLLER_TARGET_PROJECT);
        } else {
            controllerTargetProject = this.targetProject;
        }
        if (StringUtility.stringHasValue(properties.getProperty(PropertyRegistryExtension.PLUGIN_CONTROLLER_TARGET_PACKAGE))) {
            controllerTargetPackage = properties.getProperty(PropertyRegistryExtension.PLUGIN_CONTROLLER_TARGET_PACKAGE);
        }

        // enum
        if (StringUtility.isTrue(properties.getProperty(PropertyRegistryExtension.PLUGIN_ENABLE_ENUM))) {
            enableEnum = true;
        }
        if (StringUtility.stringHasValue(properties.getProperty(PropertyRegistryExtension.PLUGIN_ENUM_TARGET_PROJECT))) {
            enumTargetProject = properties.getProperty(PropertyRegistryExtension.PLUGIN_ENUM_TARGET_PROJECT);
        } else {
            enumTargetProject = this.targetProject;
        }
        if (StringUtility.stringHasValue(properties.getProperty(PropertyRegistryExtension.PLUGIN_ENUM_TARGET_PACKAGE))) {
            enumTargetPackage = properties.getProperty(PropertyRegistryExtension.PLUGIN_ENUM_TARGET_PACKAGE);
        }

        // remote
        if (StringUtility.isTrue(properties.getProperty("enableRemoteService"))) {
            enableRemoteService = true;
        }
        if (StringUtility.isTrue(properties.getProperty("enableRemoteServiceMethods"))) {
            enableRemoteServiceMethods = true;
        }
        if (StringUtility.stringHasValue(properties.getProperty("remoteServicetargetProject"))) {
            remoteServicetargetProject = properties.getProperty("remoteServicetargetProject");
        }
        if (StringUtility.stringHasValue(properties.getProperty("remoteServiceTargetPackage"))) {
            remoteServiceTargetPackage = properties.getProperty("remoteServiceTargetPackage");
        }
        if (StringUtility.stringHasValue(properties.getProperty("remoteServiceImplTargetPackage"))) {
            remoteServiceImplTargetPackage = properties.getProperty("remoteServiceImplTargetPackage");
        }
        if (StringUtility.stringHasValue(properties.getProperty("remoteQueryDTOTargetPackage"))) {
            remoteQueryDTOTargetPackage = properties.getProperty("remoteQueryDTOTargetPackage");
        }
        if (StringUtility.stringHasValue(properties.getProperty("remoteFormDTOTargetPackage"))) {
            remoteFormDTOTargetPackage = properties.getProperty("remoteFormDTOTargetPackage");
        }
        if (StringUtility.stringHasValue(properties.getProperty("remoteDTOTargetPackage"))) {
            remoteDTOTargetPackage = properties.getProperty("remoteDTOTargetPackage");
        }

        return super.validate(warnings);
    }

    @Override
    public void initialized(IntrospectedTable introspectedTable) {
        String domainSimpleName = JavaModelUtils.getDomainSimpleName(introspectedTable);
        introspectedTable.setAttribute(ExtensionConstants.ORIGINAL_CLASS_NAME, domainSimpleName);

        registerConfigMap("Service.java", introspectedTable);

        // SeviceImpl.java
        introspectedTable.setAttribute("templateName", "ServiceImpl.java");
        GeneratedTemplateFile serviceImplFile = new GeneratedTemplateFile(targetProject, targetPackage + ".impl", context, properties, introspectedTable);
        configMap.put("ServiceImpl.java", serviceImplFile);

        // Mapper.java
        introspectedTable.setAttribute("templateName", "Mapper.java");
        String mapperTargetProject = introspectedTable.getContext().getJavaClientGeneratorConfiguration().getTargetProject();
        String mapperTargetPackage = introspectedTable.getContext().getJavaClientGeneratorConfiguration().getTargetPackage();
        GeneratedTemplateFile mapperConfig = new GeneratedTemplateFile(mapperTargetProject, mapperTargetPackage, context, properties, introspectedTable);
        configMap.put("Mapper.java", mapperConfig);

        // MapperExt.xml
        introspectedTable.setAttribute("templateName", "MapperExt.xml");
        String xmlTargetProject = introspectedTable.getContext().getSqlMapGeneratorConfiguration().getTargetProject();
        String xmlTargetPackage = introspectedTable.getContext().getSqlMapGeneratorConfiguration().getTargetPackage();
        GeneratedTemplateFile xmlConfig = new GeneratedTemplateFile(xmlTargetProject, xmlTargetPackage, context, properties, introspectedTable);
        configMap.put("MapperExt.xml", xmlConfig);

        // Controller.java
        if (enableController) {
            introspectedTable.setAttribute("templateName", "Controller.java");
            GeneratedTemplateFile controllerConfig = new GeneratedTemplateFile(targetProject, controllerTargetPackage, context, properties, introspectedTable);
            configMap.put("Controller.java", controllerConfig);
        }

        // remote
        if (enableRemoteService) {
            // RemoteService.java
            introspectedTable.setAttribute("templateName", "RemoteService.java");
            GeneratedTemplateFile apiConfig = new GeneratedTemplateFile(remoteServicetargetProject, remoteServiceTargetPackage, context, properties, introspectedTable, "Remote%sService.java");
            configMap.put("RemoteService.java", apiConfig);

            // RemoteServiceImpl.java
            introspectedTable.setAttribute("templateName", "RemoteServiceImpl.java");
            GeneratedTemplateFile implConfig = new GeneratedTemplateFile(targetProject, remoteServiceImplTargetPackage, context, properties, introspectedTable, "Remote%sServiceImpl.java");
            configMap.put("RemoteServiceImpl.java", implConfig);

            // QueryDTO.java
            introspectedTable.setAttribute("templateName", "QueryDTO.java");
            GeneratedTemplateFile queryConfig = new GeneratedTemplateFile(remoteServicetargetProject, remoteQueryDTOTargetPackage, context, properties, introspectedTable);
            configMap.put("QueryDTO.java", queryConfig);

            // FormDTO.java
            introspectedTable.setAttribute("templateName", "FormDTO.java");
            GeneratedTemplateFile formConfig = new GeneratedTemplateFile(remoteServicetargetProject, remoteFormDTOTargetPackage, context, properties, introspectedTable);
            configMap.put("FormDTO.java", formConfig);

            // DTO.java
            introspectedTable.setAttribute("templateName", "DTO.java");
            GeneratedTemplateFile DTOConfig = new GeneratedTemplateFile(remoteServicetargetProject, remoteDTOTargetPackage, context, properties, introspectedTable);
            configMap.put("DTO.java", DTOConfig);
        }

        templateGenerate();
    }

    @Override
    public boolean clientGenerated(Interface interfaze, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    @Override
    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles(IntrospectedTable introspectedTable) {
        javaEnumConfig.setTargetProject(this.targetProject);
        javaEnumConfig.setServiceTargetPackage(this.targetPackage);
        javaEnumConfig.setEnableEnum(this.enableEnum);
        javaEnumConfig.setTargetPackage(this.enumTargetPackage);
        for (IntrospectedColumn column : introspectedTable.getAllColumns()) {
            if (StringUtility.stringHasValue(column.getRemarks()) && column.getRemarks().contains(" ")) {
                javaEnumConfig.putIfAbsent(column.getJavaProperty(), column);
            }
        }
        return null;
    }
}
