<#import "common.lib.java.ftl" as java> 
package ${config.targetPackage};

<#if config.properties.enableRemoteServiceMethods == 'true'>
import cn.com.duiba.wolf.utils.BeanUtils;
</#if>
import cn.tuia.mango.context.service.impl.BaseMybatisInternalServiceImpl;
<#if config.properties.enableRemoteServiceMethods == 'true'>
import ${config.properties.remoteQueryDTOTargetPackage}.${originalClassName}DTO;
import ${config.properties.remoteFormDTOTargetPackage}.${originalClassName}FormDTO;
import ${config.properties.remoteDTOTargetPackage}.${originalClassName}QueryDTO;
</#if>
import ${config.context.javaClientGeneratorConfiguration.targetPackage}.${originalClassName}Mapper;
import ${config.context.javaModelGeneratorConfiguration.targetPackage}.${originalClassName}DO;
import ${config.properties.targetPackage}.${originalClassName}Service;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
<#if config.properties.enableRemoteServiceMethods == 'true'>
import org.springframework.util.Assert;

import java.util.List;
</#if>

<@java.javaClassDoc table=config.table suffix=" ServiceImpl"/>
@Service
@Slf4j
public class ${originalClassName}ServiceImpl extends BaseMybatisInternalServiceImpl<${originalClassName}Mapper, ${originalClassName}DO> //
        implements ${originalClassName}Service {

    <#if config.properties.enableRemoteServiceMethods == 'true'>
    @Override
    public ${originalClassName}DTO queryById(Long id) {
        ${originalClassName}DO domain = getById(id);
        return BeanUtils.copy(domain, ${originalClassName}DTO.class);
    }

    @Override
    public List<${originalClassName}DTO> queryList(${originalClassName}QueryDTO queryDTO) {
        ${originalClassName}DO query = BeanUtils.copy(queryDTO, ${originalClassName}DO.class);
        List<${originalClassName}DO> list = list(query);
        return BeanUtils.copyList(list, ${originalClassName}DTO.class);
    }

    @Override
    public long queryCount(${originalClassName}QueryDTO queryDTO) {
        ${originalClassName}DO query = BeanUtils.copy(queryDTO, ${originalClassName}DO.class);
        return count(query);
    }

    @Override
    public boolean save(${originalClassName}FormDTO formDTO) {
        Assert.notNull(formDTO, "formDTO must not be null");
        ${originalClassName}DO domain = BeanUtils.copy(formDTO, ${originalClassName}DO.class);
        int affected = 0;
        if (domain.getId() == null) {
            affected = getMapper().insertSelective(domain);
        } else {
            affected = getMapper().updateByPrimaryKeySelective(domain);
        }
        return affected > 0;
    }
    </#if>

}