package cn.tuia.mango.generator.mybatis.api;

import org.mybatis.generator.api.GeneratedFile;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.internal.DefaultShellCallback;

import java.io.*;
import java.util.ArrayList;
import java.util.List;

public class TemplateGenerator {

    protected ShellCallback shellCallback;
    protected List<GeneratedFile> generatedFiles;

    private static class InstanceHolder {
        private static final TemplateGenerator instance = new TemplateGenerator();
    }

    private TemplateGenerator() {
        this.shellCallback = new DefaultShellCallback(false);
        this.generatedFiles = new ArrayList<>();
    }

    public static TemplateGenerator getInstance() {
        return InstanceHolder.instance;
    }

    public void generate() {
        for (GeneratedFile generatedFile : generatedFiles) {
            writeGeneratedFile(generatedFile);
        }
    }

    protected void writeGeneratedFile(GeneratedFile generatedFile) {
        File targetFile;
        String source;
        try {
            File project = new File(generatedFile.getTargetProject());
            if (!project.isDirectory()) {
                project.mkdirs();
            }
            File directory = shellCallback.getDirectory(generatedFile.getTargetProject(), generatedFile.getTargetPackage());

            targetFile = new File(directory, generatedFile.getFileName());
            source = generatedFile.getFormattedContent();
            writeFile(targetFile, source, "UTF-8");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void writeFile(File file, String content, String fileEncoding) throws IOException {
        FileOutputStream fos = new FileOutputStream(file, false);
        OutputStreamWriter osw;
        if (fileEncoding == null) {
            osw = new OutputStreamWriter(fos);
        } else {
            osw = new OutputStreamWriter(fos, fileEncoding);
        }

        BufferedWriter bw = new BufferedWriter(osw);
        bw.write(content);
        bw.close();
    }

    public ShellCallback getShellCallback() {
        return shellCallback;
    }

    public List<GeneratedFile> getGeneratedFiles() {
        return generatedFiles;
    }

    public void addGeneratedFile(GeneratedFile generatedFile) {
        if (generatedFile != null) {
            this.generatedFiles.add(generatedFile);
        }
    }

    public void clearGeneratedFile() {
        this.generatedFiles.clear();
    }

}
