package cn.tuia.mango.generator.mybatis.util;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Setter;
import org.mybatis.generator.internal.util.JavaBeansUtil;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author lijicong
 * @since 2020-05-27
 */
public class TableElementsUtils {

    public static final String TEMPLATE_PATH = "template/";

    @Getter
    @Setter
    @AllArgsConstructor
    public static class Table {
        private String tableName;
        private String className;
    }

    public static void print(String tables, String preffix) {
        List<Table> list = Arrays.stream(tables.split(",")).map(item -> {
            String tableName = item.trim();
            String simpeTable = tableName.replace("tb_", "");
            String className = JavaBeansUtil.getCamelCaseString(simpeTable, true);
            return new Table(tableName, className);
        }).collect(Collectors.toList());

        Map<String, Object> dataMap = new HashMap<>();
        dataMap.put("list", list);

        String content = FreeMarkerUtils.template(TEMPLATE_PATH, "table.element.ftl", dataMap);
        System.out.println(content);
    }

    public static void main(String[] args) {
        String tables = "tb_table1, tb_table2, tb_table3";
        print(tables, "tb_");
    }

}
