<#--noinspection ALL-->
<template>
  <div class="app-container">
    <!--工具栏-->
    <div class="head-container">
      <!-- 搜索 -->
      <el-input v-model="query.value" clearable placeholder="输入搜索内容" style="width: 200px;" class="filter-item" @keyup.enter.native="handlSearch"/>
      <el-select v-model="query.type" clearable placeholder="类型" class="filter-item" style="width: 130px">
        <el-option v-for="item in queryTypeOptions" :key="item.key" :label="item.label" :value="item.key"/>
      </el-select>
      <el-button class="filter-item" size="mini" type="success" icon="el-icon-search" @click="handlSearch">搜索</el-button>
    </div>
    <div class="x-orange-buttons">
      <!-- 新增 -->
      <el-button v-permission="['admin','${table.entityPath?replace("DO","")}:add']" class="filter-item" size="mini" type="primary" @click="handleAdd">新增</el-button>
    </div>
    <!--表单组件-->
    <eForm ref="form" :is-add="isAdd"/>
    <!--表格渲染-->
    <el-table v-loading="loading" :data="data" size="small" border fit highlight-current-row style="width: 100%;">
      <el-table-column type="selection"/>
      <el-table-column prop="id" label="ID"/>
      <#list table.allColumns as field>
        <#if field.fullyQualifiedJavaType.shortName != 'Date'>
      <el-table-column prop="${field.javaProperty}" label="${cfg.StringHelper.getSimpleComment(field.remarks)}"/>
        <#else>
      <el-table-column prop="${field.javaProperty}" label="${cfg.StringHelper.getSimpleComment(field.remarks)}">
        <template slot-scope="scope">
          <span>{{ parseTime(scope.row.${field.javaProperty}) }}</span>
        </template>
      </el-table-column>
        </#if>
      </#list>
      <el-table-column v-if="checkPermission(['admin','${table.entityPath?replace("DO","")}:edit','${table.entityPath?replace("DO","")}:del'])" label="操作" width="150px" align="center">
        <template slot-scope="scope">
          <el-button v-permission="['admin','${table.entityPath?replace("DO","")}:edit']" size="mini" type="primary" @click="handleEdit(scope.row)">编辑</el-button>
          <el-button v-permission="['admin','${table.entityPath?replace("DO","")}:del']" size="mini" type="danger" @click="handleDelete(scope.row.id)">删除</el-button>
        </template>
      </el-table-column>
    </el-table>
    <#if cfg.TableInfoUtil.isTree(cfg.gc)><#else>
    <!--分页组件-->
    <el-pagination :total="total" :current-page="page + 1" layout="total, prev, pager, next, sizes" @size-change="sizeChange" @current-change="pageChange"/></#if>
  </div>
</template>

<script>
import checkPermission from '@/utils/permission'
import table from '@/mixins/table'
import { pageApi, <#if cfg.TableInfoUtil.isTree(cfg.gc)>pageTreeApi, </#if>deleteApi } from '@/${cfg.StringHelper.path(cfg.gc, table)}'
<#if cfg.TableInfoUtil.hasDate(table)>
import { parseTime } from '@/utils/index'
</#if>
import eForm from './vue${table.entityPath?replace("DO","")}Form'
export default {
  components: { eForm },
  mixins: [table],
  data() {
    return {
      queryTypeOptions: [
        <#list table.fields as field>
        { key: '${field.propertyName}', label: '${cfg.StringHelper.getSimpleComment(field.comment)}' }<#if field_has_next>,</#if>
        </#list>
      ]
    }
  },
  created() {
    this.$nextTick(() => {
      this.init()
    })
  },
  methods: {
  <#if cfg.TableInfoUtil.hasDate(table)>
    parseTime,
  </#if>
    checkPermission,
    beforeInit() {
      this.pageApi = <#if cfg.TableInfoUtil.isTree(cfg.gc)>pageTreeApi<#else>pageApi</#if>
      const sort = 'id'
      this.params = { page: this.page, size: this.size, sort: sort }
      const query = this.query
      const type = query.type
      const value = query.value
      if (type && value) { this.params[type] = value }
      return true
    },
    handleDelete(id) {
      this.$confirm('确定删除本条数据吗？', '提示').then(() => {
        this.delLoading = true
        deleteApi(id).then(res => {
          this.deleteChange()
          this.init()
          this.$notify({
            title: '删除成功',
            type: 'success',
            duration: 2500
          })
        }).catch(err => {
          console.log(err)
        })
      })
    },
    handleAdd() {
      this.isAdd = true
      this.$refs.form.dialog = true
    },
    handleEdit(row) {
      this.isAdd = false
      const data = {}
      const form = this.$refs.form
      form.data = Object.assign(data, row)
      form.dialog = true
    }
  }
}
</script>

<style scoped>

</style>
