package cn.tuia.tuia.treasure.center.interceptor;

import cn.com.duiba.boot.exception.BizException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * 远程调用接口统一异常拦截器
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RemoteServiceAspect.java , v 0.1 2018/1/3 上午10:18 ZhouFeng Exp $
 */
@Aspect
@Component
public class RemoteServiceAspect {

    /**
     * logger
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteServiceAspect.class);


    // 切入点表达式按需配置
    @Pointcut("execution(* cn.tuia.tuia.treasure.center.remoteservice.impl.*.*(..)))")
    private void myPointcut() {
    }

    @Around(value = "RemoteServiceAspect.myPointcut()")
    public Object around(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object result;
        try {
            result = proceedingJoinPoint.proceed();
        } catch (Exception e) {
            if (!(e instanceof BizException)) {
                LOGGER.error("接口发生异常", e);
            }
            //其他异常直接抛出，使其触发熔断
            throw e;
        }
        return result;
    }

}
