package cn.tuia.explore.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.explore.center.api.dto.req.PostFlowReqDto;
import cn.tuia.explore.center.api.dto.req.PostPublishDto;
import cn.tuia.explore.center.api.dto.rsp.PostDto;

import java.util.List;

/**
 * 帖子相关服务
 *
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: RemotePostService.java , v 0.1 2019-05-23 16:58 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemotePostService {


    List<PostDto> flow(PostFlowReqDto reqDto);


    /**
     * 发布帖子
     *
     * @param postPublishDto
     */
    void publish(PostPublishDto postPublishDto) throws BizException;


    /**
     * 查询帖子
     *
     * @param postId
     * @return
     */
    PostDto queryPost(long postId) throws BizException;


    void share(long postId) throws BizException;

}
