package cn.tuia.explore.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.explore.center.api.dto.req.LoginDto;
import cn.tuia.explore.center.api.dto.req.UserAchieverDto;
import cn.tuia.explore.center.api.dto.rsp.LoginRspDto;
import cn.tuia.explore.center.api.dto.rsp.UserDto;

import java.util.List;
import java.util.Map;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: RemoteUserService.java , v 0.1 2019-05-17 10:56 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteUserService {

    /**
     * 用户登录
     *
     * @param loginDto
     * @return
     * @throws BizException
     */
    LoginRspDto login(LoginDto loginDto) throws BizException;


    /**
     * 通过token换取真实userid
     *
     * @param token
     * @return 当token不合法时返回null
     * @throws BizException
     */
    Long tokenExchage(String token) throws BizException;


    /**
     * 查询用户信息
     *
     * @param userIds
     * @return
     */
    Map<Long, UserDto> queryUsers(List<Long> userIds);

    /**
     * 查询用户成就
     *
     * @param userId
     * @return
     */
    UserAchieverDto queryUserAchiever(Long userId) throws BizException;


}
