/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.api.enums;

import cn.tuia.explore.center.api.dto.general.AbstractMessageContent;
import cn.tuia.explore.center.api.dto.general.AttentionMessage;
import cn.tuia.explore.center.api.dto.general.LikeMessage;
import cn.tuia.explore.center.api.dto.general.ReplyCommentMessage;
import cn.tuia.explore.center.api.dto.general.ReplyPostMessage;
import cn.tuia.explore.center.api.dto.general.SystemMessage;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum MessageType {
    LIKE(1, LikeMessage.class),
    REPLY_COMMENT(2, ReplyCommentMessage.class),
    REPLY_POST(3, ReplyPostMessage.class),
    ATTENTION(4, AttentionMessage.class),
    SYSTEM(5, SystemMessage.class);

    private int code;
    private Class<? extends AbstractMessageContent> clazz;
    private static final Map<Integer, MessageType> CACHE;

    public static MessageType of(int code) {
        return CACHE.get(code);
    }

    private MessageType(int code, Class<? extends AbstractMessageContent> clazz) {
        this.code = code;
        this.clazz = clazz;
    }

    public int getCode() {
        return this.code;
    }

    public Class<? extends AbstractMessageContent> getClazz() {
        return this.clazz;
    }

    static {
        CACHE = Arrays.stream(MessageType.values()).collect(Collectors.toMap(MessageType::getCode, p -> p));
    }
}

