/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum UserOperationType {
    PUBLISH_POST(1, true, false, true, false),
    REPLY_TO_COMMENT(2, true, true, true, true),
    REPLY_TO_POST(3, true, true, true, true),
    LIKE_COMMENT(4, true, true, false, true),
    LIKE_POST(5, true, true, false, true),
    SHARE_POST(6, true, true, false, false),
    VISIT_HOME_PAGE(7, true, true, false, false),
    FOLLOW_USER(8, true, true, false, false);

    private static final Map<Integer, UserOperationType> CACHE;
    private int code;
    private boolean activeUser;
    private boolean passiveUser;
    private boolean activeId;
    private boolean passiveId;

    public static UserOperationType of(int code) {
        return CACHE.get(code);
    }

    private UserOperationType(int code, boolean activeUser, boolean passiveUser, boolean activeId, boolean passiveId) {
        this.code = code;
        this.activeUser = activeUser;
        this.passiveUser = passiveUser;
        this.activeId = activeId;
        this.passiveId = passiveId;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isActiveUser() {
        return this.activeUser;
    }

    public boolean isPassiveUser() {
        return this.passiveUser;
    }

    public boolean isActiveId() {
        return this.activeId;
    }

    public boolean isPassiveId() {
        return this.passiveId;
    }

    static {
        CACHE = Arrays.stream(UserOperationType.values()).collect(Collectors.toMap(UserOperationType::getCode, p -> p));
    }
}

