package cn.tuia.explore.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.explore.center.api.dto.rsp.AppConfigDto;

import java.util.List;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: RemoteAppConfigService.java , v 0.1 2019-06-21 14:37 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteAppConfigService {

    /**
     * 查询单个配置
     *
     * @param key
     * @param version
     * @param platform
     * @return
     * @see cn.tuia.explore.center.api.enums.Platform
     */
    AppConfigDto queryConfigByKey(String key, long version, int platform);

    /**
     * 查询符合版本和平台要求的配置
     *
     * @param version
     * @param platform
     * @return
     * @see cn.tuia.explore.center.api.enums.Platform
     */
    List<AppConfigDto> queryConfig(long version, int platform);

    /**
     * 插入一个配置
     *
     * @param config
     * @return
     * @throws BizException
     */
    boolean insertConfig(AppConfigDto config) throws BizException;

}
