package cn.tuia.explore.center.api.dto.general;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: AttentionMessage.java , v 0.1 2019-05-29 09:33 ElinZhou Exp $
 */
public class AttentionMessage extends AbstractMessageContent {
    private static final long serialVersionUID = 8897462829907590808L;

    private static final String TEMPLATE = "%s关注了你";

    private long userId;

    private transient String nickName;

    private transient String headImage;

    @Override
    protected Long userId() {
        return userId;
    }

    @Override
    protected String title() {
        return String.format(TEMPLATE, nickName);
    }

    @Override
    protected String content() {
        return "我关注了你，对你很感兴趣";
    }

    @Override
    protected String icon() {
        return headImage;
    }

    public long getUserId() {
        return userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getHeadImage() {
        return headImage;
    }

    public void setHeadImage(String headImage) {
        this.headImage = headImage;
    }
}
