package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: Platform.java , v 0.1 2019-06-13 10:54 ElinZhou Exp $
 */
public enum Platform {

    ANDROID(0),
    IOS(1),
    BOTH(2),

    ;
    private int code;

    private static final Map<Integer, Platform> CACHE =
            Arrays.stream(Platform.values()).collect(Collectors.toMap(Platform::getCode, p -> p));

    public static Platform of(int code) {
        return CACHE.get(code);
    }

    Platform(int code) {
        this.code = code;
    }

    public int getCode() {

        return code;
    }


}
