package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 调用场景
 *
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: PostFlowFetchType.java , v 0.1 2019-05-23 15:43 ElinZhou Exp $
 */
public enum PostFlowFetchType {

    /**
     * 关注页面
     */
    FOLLOW_PAGE(1, true, true),

    /**
     * 推荐页面
     */
    RECOMMEND_PAGE(2, false, true),

    /**
     * 个人页面
     */
    PERSIONAL_PAGE(3, true, false),

    /**
     * 圈子
     */
    GROUP_PAGE(4, false, false),

    /**
     * 图片
     */
    IMAGE(5, false, false),

    /**
     * 视频
     */
    VIDEO(6, false, false),

    /**
     * 频道
     */
    CHANNEL(7, false, false),

    ;
    private Integer code;

    private boolean needLogin;

    private boolean show;

    private static final Map<Integer, PostFlowFetchType> CACHE =
            Arrays.stream(PostFlowFetchType.values()).collect(Collectors.toMap(PostFlowFetchType::getCode, p -> p));

    PostFlowFetchType(Integer code, boolean needLogin, boolean show) {
        this.code = code;
        this.needLogin = needLogin;
        this.show = show;
    }

    public boolean isNeedLogin() {
        return needLogin;
    }

    public Integer getCode() {
        return code;
    }

    public static PostFlowFetchType of(Integer code) {
        return CACHE.get(code);
    }

    public boolean isShow() {
        return show;
    }}

