package cn.tuia.explore.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.explore.center.api.dto.req.BaseQueryDto;
import cn.tuia.explore.center.api.dto.req.BindingPhoneNumDto;
import cn.tuia.explore.center.api.dto.req.LoginDto;
import cn.tuia.explore.center.api.dto.req.SendVerifyCodeDto;
import cn.tuia.explore.center.api.dto.req.UserAchieverDto;
import cn.tuia.explore.center.api.dto.req.UserSearchReqDto;
import cn.tuia.explore.center.api.dto.rsp.LoginRspDto;
import cn.tuia.explore.center.api.dto.rsp.PageQueryResultDto;
import cn.tuia.explore.center.api.dto.rsp.UserDto;

import java.util.List;
import java.util.Map;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: RemoteUserService.java , v 0.1 2019-05-17 10:56 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteUserService {

    /**
     * 用户登录
     *
     * @param loginDto
     * @return
     * @throws BizException
     */
    LoginRspDto login(LoginDto loginDto) throws BizException;


    /**
     * 通过token换取真实userid
     *
     * @param token
     * @return 当token不合法时返回null
     * @throws BizException
     */
    Long tokenExchage(String token) throws BizException;


    /**
     * 查询用户信息
     *
     * @param userIds
     * @return
     */
    Map<Long, UserDto> queryUsers(List<Long> userIds);

    /**
     * 查询用户成就
     *
     * @param userId
     * @return
     */
    UserAchieverDto queryUserAchiever(Long userId) throws BizException;


    /**
     * 更新用户资料
     *
     * @param userDto
     * @return
     */
    boolean updateUserData(UserDto userDto);


    /**
     * 随机假用户列表
     *
     * @return
     */
    List<UserDto> randomFakeUser(BaseQueryDto baseQueryDto);


    /**
     * 随机用户列表
     *
     * @param baseQueryDto
     * @return
     */
    List<UserDto> randomUser(BaseQueryDto baseQueryDto);

    /**
     * 发送验证码
     *
     * @param sendVerifyCodeDto
     * @return
     */
    boolean sendVerifyCode(SendVerifyCodeDto sendVerifyCodeDto) throws BizException;


    /**
     * 绑定手机号
     *
     * @param bindingPhoneNumDto
     * @return
     * @throws BizException
     */
    boolean bindingPhoneNum(BindingPhoneNumDto bindingPhoneNumDto) throws BizException;


    /**
     * 分页查询假用户
     *
     * @param baseQueryDto
     * @return
     */
    PageQueryResultDto<UserDto> pageQueryFakeUser(BaseQueryDto baseQueryDto);

    /**
     * 通过昵称查询用户
     *
     * @param dto
     * @return
     */
    PageQueryResultDto<UserDto> search(UserSearchReqDto dto) throws BizException;
}
