/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum PostChannel {
    HOT("\u70ed\u70b9", 1),
    HEALTH("\u517b\u751f", 2),
    EMOTION("\u60c5\u611f", 3),
    FUNNY("\u641e\u7b11", 4);

    private static final Map<Integer, PostChannel> CACHE;
    private String title;
    private int code;

    private PostChannel(String title, int code) {
        this.title = title;
        this.code = code;
    }

    public String getTitle() {
        return this.title;
    }

    public int getCode() {
        return this.code;
    }

    public PostChannel of(int code) {
        return CACHE.get(code);
    }

    static {
        CACHE = Arrays.stream(PostChannel.values()).collect(Collectors.toMap(PostChannel::getCode, p -> p));
    }
}

