/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.api.enums;

import cn.tuia.explore.center.api.enums.PostGroup;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum PostSourceType {
    UNKNOW("\u672a\u77e5", 999, PostGroup.LINK),
    ORIGINAL("\u539f\u521b", 0, PostGroup.LINK),
    GONGZHONGHAO("\u516c\u4f17\u53f7", 1, PostGroup.ARTICLE),
    KUAISHOU("\u5feb\u624b", 2, PostGroup.LINK),
    DOUYIN("\u6296\u97f3", 3, PostGroup.LINK),
    PIPIXIA("\u76ae\u76ae\u867e", 4, PostGroup.VIDEO),
    MEIPIAN("\u7f8e\u7bc7", 5, PostGroup.ARTICLE),
    TIAO_BA("\u8df3\u5427\u5e7f\u573a\u821e", 7, PostGroup.VIDEO),
    LISHIPIN("\u68a8\u89c6\u9891", 8, PostGroup.VIDEO),
    XIGUASHIPIN("\u897f\u74dc\u89c6\u9891", 9, PostGroup.VIDEO),
    TOUTIAOSHEYING("\u5934\u6761\u6444\u5f71\u96c6", 10, PostGroup.IMAGE),
    XINLANGTUPIAN("\u65b0\u6d6a\u56fe\u7247", 11, PostGroup.IMAGE);

    private static final Map<Integer, PostSourceType> CACHE;
    private String name;
    private int code;
    private PostGroup postGroup;

    private PostSourceType(String name, int code, PostGroup postGroup) {
        this.name = name;
        this.code = code;
        this.postGroup = postGroup;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public PostGroup getPostGroup() {
        return this.postGroup;
    }

    public static PostSourceType of(int code) {
        return CACHE.get(code);
    }

    static {
        CACHE = Arrays.stream(PostSourceType.values()).collect(Collectors.toMap(PostSourceType::getCode, p -> p));
    }
}

