/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.explore.center.api.enums;

import cn.tuia.explore.center.api.enums.VerifyType;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public enum VerifyScene {
    PHONE_SMS_BINDING(1, VerifyType.SMS, 10L, TimeUnit.MINUTES, 55L, TimeUnit.SECONDS),
    PHONE_LOGIN(2, VerifyType.SMS, 10L, TimeUnit.MINUTES, 55L, TimeUnit.SECONDS);

    private int code;
    private VerifyType type;
    private long expireTime;
    private TimeUnit expireUnit;
    private long refreshTime;
    private TimeUnit refreshUnit;
    private static final Map<Integer, VerifyScene> CACHE;

    public static VerifyScene of(int code) {
        return CACHE.get(code);
    }

    private VerifyScene(int code, VerifyType type, long expireTime, TimeUnit expireUnit, long refreshTime, TimeUnit refreshUnit) {
        this.code = code;
        this.type = type;
        this.expireTime = expireTime;
        this.expireUnit = expireUnit;
        this.refreshTime = refreshTime;
        this.refreshUnit = refreshUnit;
    }

    public int getCode() {
        return this.code;
    }

    public VerifyType getType() {
        return this.type;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public TimeUnit getExpireUnit() {
        return this.expireUnit;
    }

    public long getRefreshTime() {
        return this.refreshTime;
    }

    public TimeUnit getRefreshUnit() {
        return this.refreshUnit;
    }

    static {
        CACHE = Arrays.stream(VerifyScene.values()).collect(Collectors.toMap(VerifyScene::getCode, v -> v));
    }
}

