package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: PostChannel.java , v 0.1 2019-07-14 15:40 ElinZhou Exp $
 */
public enum PostChannel {

    HOT("热点", 1),
    HEALTH("养生", 2),
    EMOTION("情感", 3),
    FUNNY("搞笑", 4),
    ;


    private static final Map<Integer, PostChannel> CACHE =
            Arrays.stream(PostChannel.values()).collect(Collectors.toMap(PostChannel::getCode, p -> p));

    PostChannel(String title, int code) {
        this.title = title;
        this.code = code;
    }

    private String title;
    private int code;

    public String getTitle() {
        return title;
    }

    public int getCode() {
        return code;
    }

    public static PostChannel of(Integer code) {
        return CACHE.get(code);
    }
}
