package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 调用场景
 *
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: PostFlowFetchType.java , v 0.1 2019-05-23 15:43 ElinZhou Exp $
 */
public enum PostFlowFetchType {

    /**
     * 关注页面
     */
    FOLLOW_PAGE(1, true),

    /**
     * 推荐页面
     */
    RECOMMEND_PAGE(2, false),

    /**
     * 个人页面
     */
    PERSIONAL_PAGE(3, true),

    /**
     * 圈子
     */
    GROUP_PAGE(4, false),

    /**
     * 图片
     */
    IMAGE(5, false),

    /**
     * 视频
     */
    VIDEO(6, false),

    /**
     * 频道
     */
    CHANNEL(7,false),

    ;
    private Integer code;

    private boolean needLogin;

    private static final Map<Integer, PostFlowFetchType> CACHE =
            Arrays.stream(PostFlowFetchType.values()).collect(Collectors.toMap(PostFlowFetchType::getCode, p -> p));

    PostFlowFetchType(Integer code, boolean needLogin) {
        this.code = code;
        this.needLogin = needLogin;
    }

    public boolean isNeedLogin() {
        return needLogin;
    }

    public Integer getCode() {
        return code;
    }

    public static PostFlowFetchType of(Integer code) {
        return CACHE.get(code);
    }


}

