package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: PostSourceType.java , v 0.1 2019-05-23 17:05 ElinZhou Exp $
 */
public enum PostSourceType {

    /**
     * 未知
     */
    UNKNOW("未知", 999, PostGroup.LINK),

    /**
     * 原创
     */
    ORIGINAL("原创", 0, PostGroup.LINK),

    /**
     * 公众号
     */
    GONGZHONGHAO("公众号", 1, PostGroup.ARTICLE),

    /**
     * 快手
     */
    KUAISHOU("快手", 2, PostGroup.LINK),

    /**
     * 抖音
     */
    DOUYIN("抖音", 3, PostGroup.LINK),

    /**
     * 皮皮虾
     */
    PIPIXIA("皮皮虾", 4, PostGroup.VIDEO),

    /**
     * 美篇
     */
    MEIPIAN("美篇", 5, PostGroup.ARTICLE),

    TIAO_BA("跳吧广场舞", 7, PostGroup.VIDEO),

    LISHIPIN("梨视频", 8, PostGroup.VIDEO),

    XIGUASHIPIN("西瓜视频", 9, PostGroup.VIDEO),

    TOUTIAOSHEYING("头条摄影集", 10, PostGroup.IMAGE),

    XINLANGTUPIAN("新浪图片", 11, PostGroup.IMAGE),

    SOUGOU_WEIXIN("公众号", 12, PostGroup.ARTICLE),

    TX_XINWEN_SHEHUI("腾讯新闻", 13, PostGroup.ARTICLE),

    TX_XINWEN_NEWS_24("腾讯新闻", 14, PostGroup.ARTICLE),

    ;


    private static final Map<Integer, PostSourceType> CACHE =
            Arrays.stream(PostSourceType.values()).collect(Collectors.toMap(PostSourceType::getCode, p -> p));

    PostSourceType(String name, int code, PostGroup postGroup) {
        this.name = name;
        this.code = code;
        this.postGroup = postGroup;
    }

    private String name;

    private int code;

    private PostGroup postGroup;

    public int getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public PostGroup getPostGroup() {
        return postGroup;
    }

    public static PostSourceType of(int code) {
        return CACHE.get(code);
    }

}
