package cn.tuia.explore.center.api.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * 用户登录方式
 * @author ElinZhou
 * @version $Id: UserLoginType.java , v 0.1 2017/12/28 下午2:37 ElinZhou Exp $
 */
public enum UserLoginType {

    /**
     * 微信登录
     */
    WECHAT(1),

    /**
     * 内部测试账号登录
     */
    FAKE(2),

    /**
     * 手机号登录
     */
    PHONE(3),

    ;
    private int code;

    UserLoginType(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    private static final Map<Integer, UserLoginType> CACHE = Maps.uniqueIndex(Arrays.asList(UserLoginType.values()),
            UserLoginType::getCode);


    public static UserLoginType getByCode(Integer taskId) {
        UserLoginType userLoginType = CACHE.get(taskId);
        if (userLoginType != null) {
            return userLoginType;
        }
        return null;
    }




}
