package cn.tuia.explore.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.explore.center.api.enums.CreditOpSource;
import cn.tuia.explore.center.api.enums.CreditOrderStatus;
import cn.tuia.explore.center.api.enums.CreditTradeCode;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: RemoteCreditService.java , v 0.1 2019-07-14 10:26 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteCreditService {

    /**
     * 查询余额
     *
     * @param userId
     * @return
     */
    long queryBalance(long userId);

    /**
     * 余额变更
     *
     * @param userId
     * @param fee
     * @param orderNumber
     * @param code
     * @param opSource
     * @param orderStatus
     * @return
     * @throws BizException
     */
    Long change(long userId, long fee, String orderNumber, CreditTradeCode code, CreditOpSource opSource,
                CreditOrderStatus orderStatus) throws BizException;


    /**
     * 退还
     *
     * @param orderNumber
     * @throws BizException
     */
    void refund(String orderNumber, CreditOrderStatus status) throws BizException;
}
