package cn.tuia.explore.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.explore.center.api.dto.rsp.NewsCollectionDto;
import cn.tuia.explore.center.api.dto.rsp.NewsCollectionOverviewDto;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: RemoteNewsCollectionService.java , v 0.1 2019-07-15 19:24 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteNewsCollectionService {

    /**
     * 查询最新的合辑
     *
     * @return
     */
    NewsCollectionOverviewDto newest() throws BizException;

    /**
     * 查询合辑内容
     *
     * @param newsId
     * @return
     */
    NewsCollectionDto queryByNewsId(long newsId) throws BizException;

}
