package cn.tuia.explore.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.explore.center.api.dto.req.PostDeleteDto;
import cn.tuia.explore.center.api.dto.req.PostFlowReqDto;
import cn.tuia.explore.center.api.dto.req.PostPublishDto;
import cn.tuia.explore.center.api.dto.req.UserPostPageReq;
import cn.tuia.explore.center.api.dto.rsp.MiniPostDto;
import cn.tuia.explore.center.api.dto.rsp.PageQueryResultDto;
import cn.tuia.explore.center.api.dto.rsp.PostDetailDto;
import cn.tuia.explore.center.api.dto.rsp.PostDto;

import java.util.List;

/**
 * 帖子相关服务
 *
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: RemotePostService.java , v 0.1 2019-05-23 16:58 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemotePostService {

    /**
     * 获取信息流
     *
     * @param reqDto
     * @return
     */
    List<PostDto> flow(PostFlowReqDto reqDto) throws BizException;

    /**
     * 查询某个用户的所有动态
     *
     * @param req
     * @return
     */
    PageQueryResultDto<PostDto> userPostPageQuery(UserPostPageReq req);


    /**
     * 发布帖子
     *
     * @param postPublishDto
     */
    Long publish(PostPublishDto postPublishDto) throws BizException;


    /**
     * 查询帖子
     *
     * @param postId
     * @return
     */
    PostDetailDto queryPost(long postId) throws BizException;


    void share(long postId) throws BizException;

    /**
     * 删除动态
     *
     * @param deleteDto
     * @return
     * @throws BizException
     */
    boolean delete(PostDeleteDto deleteDto) throws BizException;


    /**
     * 获取今日要闻
     *
     * @return
     */
    List<MiniPostDto> todayFocus();


    /**
     * 查询动态的关键词
     */
    List<String> keywords(long postId);


}
