package cn.tuia.explore.center.api.enums;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: PostContentType.java , v 0.1 2019-07-14 16:01 ElinZhou Exp $
 */
@SuppressWarnings("squid:S00115")
public enum PostContentType {

    西瓜视频_宠物(PostSourceType.XIGUASHIPIN, "6141508406", Collections.emptyList(), Lists.newArrayList(UserLikeTag.PET), Lists.newArrayList(1210L)),
    西瓜视频_农人(PostSourceType.XIGUASHIPIN, "61887739390", Collections.emptyList(), Lists.newArrayList(UserLikeTag.SOCIETY), Lists.newArrayList(1228L)),
    西瓜视频_社会(PostSourceType.XIGUASHIPIN, "61887739370", Lists.newArrayList(PostChannel.HOT), Lists.newArrayList(UserLikeTag.SOCIETY), Lists.newArrayList(1225L)),
    西瓜视频_懂车帝(PostSourceType.XIGUASHIPIN, "7005980951", Collections.emptyList(), Lists.newArrayList(UserLikeTag.CAR), Lists.newArrayList(1300L)),
    西瓜视频_娱乐(PostSourceType.XIGUASHIPIN, "61887739374", Collections.emptyList(), Lists.newArrayList(UserLikeTag.ENTERTAINMENT), Lists.newArrayList(1305L)),
    西瓜视频_影视(PostSourceType.XIGUASHIPIN, "61887739373", Collections.emptyList(), Collections.emptyList(), Lists.newArrayList(1226L)),
    西瓜视频_时尚(PostSourceType.XIGUASHIPIN, "6141508390", Collections.emptyList(), Lists.newArrayList(UserLikeTag.FASHION), Lists.newArrayList(1296L)),
    西瓜视频_游戏(PostSourceType.XIGUASHIPIN, "61887739376", Collections.emptyList(), Lists.newArrayList(UserLikeTag.GAME), Collections.emptyList()),
    西瓜视频_手工(PostSourceType.XIGUASHIPIN, "94349531488", Collections.emptyList(), Lists.newArrayList(UserLikeTag.LIFE), Collections.emptyList()),
    西瓜视频_综艺(PostSourceType.XIGUASHIPIN, "61887739345", Collections.emptyList(), Lists.newArrayList(UserLikeTag.ENTERTAINMENT), Lists.newArrayList(1222L)),
    西瓜视频_美食(PostSourceType.XIGUASHIPIN, "6141508391", Collections.emptyList(), Lists.newArrayList(UserLikeTag.FOOD), Lists.newArrayList(1231L)),
    西瓜视频_广场舞(PostSourceType.XIGUASHIPIN, "61887739388", Collections.emptyList(), Lists.newArrayList(UserLikeTag.SOCIETY), Lists.newArrayList(1338L)),
    西瓜视频_亲子(PostSourceType.XIGUASHIPIN, "61887739344", Collections.emptyList(), Lists.newArrayList(UserLikeTag.PARENT_CHILD), Collections.emptyList()),
    西瓜视频_搞笑(PostSourceType.XIGUASHIPIN, "61887739369", Lists.newArrayList(PostChannel.FUNNY), Lists.newArrayList(UserLikeTag.FUNNY), Lists.newArrayList(1218L)),
    西瓜视频_音乐(PostSourceType.XIGUASHIPIN, "61887739368", Collections.emptyList(), Lists.newArrayList(UserLikeTag.MUSIC), Lists.newArrayList(1223L)),
    西瓜视频_文化(PostSourceType.XIGUASHIPIN, "6141508399", Collections.emptyList(), Lists.newArrayList(UserLikeTag.CULTURE), Lists.newArrayList(1205L)),
    西瓜视频_体育(PostSourceType.XIGUASHIPIN, "5798809184", Collections.emptyList(), Lists.newArrayList(UserLikeTag.SPORTS), Lists.newArrayList(1299L)),
    西瓜视频_科技(PostSourceType.XIGUASHIPIN, "6141508396", Collections.emptyList(), Lists.newArrayList(UserLikeTag.TECHNOLOGY), Lists.newArrayList(1253L)),
    西瓜视频_儿童(PostSourceType.XIGUASHIPIN, "6141508395", Collections.emptyList(), Lists.newArrayList(UserLikeTag.PARENT_CHILD), Collections.emptyList()),
    头条摄影集_0(PostSourceType.TOUTIAOSHEYING, "0", Collections.emptyList(), Lists.newArrayList(UserLikeTag.PHOTOGRAPHY), Lists.newArrayList(1004L, 1012L)),
    跳吧广场舞_0(PostSourceType.TIAO_BA, "0", Collections.emptyList(), Lists.newArrayList(UserLikeTag.SQUARE_DANCE), Lists.newArrayList(1153L)),
    皮皮虾_0(PostSourceType.PIPIXIA, "0", Collections.emptyList(), Lists.newArrayList(UserLikeTag.FUNNY), Lists.newArrayList(1165L, 1284L, 1319L)),
    新浪图片_0(PostSourceType.XINLANGTUPIAN, "0", Collections.emptyList(), Lists.newArrayList(UserLikeTag.PHOTOGRAPHY), Lists.newArrayList(1039L, 1035L)),
    梨视频_社会(PostSourceType.LISHIPIN, "1", Lists.newArrayList(PostChannel.HOT), Lists.newArrayList(UserLikeTag.SOCIETY), Lists.newArrayList(1136L)),
    梨视频_实结(PostSourceType.LISHIPIN, "2", Collections.emptyList(), Lists.newArrayList(UserLikeTag.SOCIETY), Lists.newArrayList(1140L)),
    梨视频_财富(PostSourceType.LISHIPIN, "3", Collections.emptyList(), Lists.newArrayList(UserLikeTag.FINANCE), Lists.newArrayList(1156L)),
    梨视频_娱乐(PostSourceType.LISHIPIN, "4", Collections.emptyList(), Lists.newArrayList(UserLikeTag.ENTERTAINMENT), Lists.newArrayList(1146L)),
    梨视频_音乐(PostSourceType.LISHIPIN, "59", Collections.emptyList(), Lists.newArrayList(UserLikeTag.MUSIC), Lists.newArrayList(1182L)),
    梨视频_生活(PostSourceType.LISHIPIN, "5", Collections.emptyList(), Lists.newArrayList(UserLikeTag.LIFE), Lists.newArrayList(1138L)),
    梨视频_美食(PostSourceType.LISHIPIN, "6", Collections.emptyList(), Lists.newArrayList(UserLikeTag.FOOD), Lists.newArrayList(1179L)),
    梨视频_科技(PostSourceType.LISHIPIN, "8", Collections.emptyList(), Lists.newArrayList(UserLikeTag.TECHNOLOGY), Lists.newArrayList(1141L)),
    梨视频_体育(PostSourceType.LISHIPIN, "9", Collections.emptyList(), Lists.newArrayList(UserLikeTag.SPORTS), Lists.newArrayList(1143L)),
    梨视频_汽车(PostSourceType.LISHIPIN, "31", Collections.emptyList(), Lists.newArrayList(UserLikeTag.CAR), Lists.newArrayList(1155L)),
    梨视频_新知(PostSourceType.LISHIPIN, "10", Collections.emptyList(), Lists.newArrayList(UserLikeTag.SOCIETY), Lists.newArrayList(1130L)),
    美篇_影视(PostSourceType.MEIPIAN, "TV", Collections.emptyList(), Lists.newArrayList(UserLikeTag.ENTERTAINMENT), Lists.newArrayList(1332L)),
    美篇_情感(PostSourceType.MEIPIAN, "emotion", Collections.emptyList(), Lists.newArrayList(UserLikeTag.EMOTION), Lists.newArrayList(1007L)),
    美篇_女神(PostSourceType.MEIPIAN, "beauty", Collections.emptyList(), Lists.newArrayList(UserLikeTag.PHOTOGRAPHY), Lists.newArrayList(1044L)),
    美篇_美文(PostSourceType.MEIPIAN, "fiction", Collections.emptyList(), Lists.newArrayList(UserLikeTag.LIFE), Lists.newArrayList(1014L)),
    美篇_摄影(PostSourceType.MEIPIAN, "photo", Collections.emptyList(), Lists.newArrayList(UserLikeTag.PHOTOGRAPHY), Lists.newArrayList(1050L)),
    美篇_生活(PostSourceType.MEIPIAN, "life", Collections.emptyList(), Lists.newArrayList(UserLikeTag.LIFE), Lists.newArrayList(1023L)),
    美篇_旅行(PostSourceType.MEIPIAN, "tour", Collections.emptyList(), Lists.newArrayList(UserLikeTag.TOURISM), Lists.newArrayList(1074L)),
    美篇_美食(PostSourceType.MEIPIAN, "food", Collections.emptyList(), Lists.newArrayList(UserLikeTag.FOOD), Lists.newArrayList(1134L)),
    美篇_兴趣(PostSourceType.MEIPIAN, "hobby", Collections.emptyList(), Lists.newArrayList(UserLikeTag.LIFE), Lists.newArrayList(1025L)),
    公众号_科技(PostSourceType.GONGZHONGHAO, "科技", Collections.emptyList(), Lists.newArrayList(UserLikeTag.TECHNOLOGY), Lists.newArrayList(1219L)),
    公众号_美食(PostSourceType.GONGZHONGHAO, "美食", Collections.emptyList(), Lists.newArrayList(UserLikeTag.FOOD), Lists.newArrayList(1242L)),
    公众号_宠物(PostSourceType.GONGZHONGHAO, "宠物", Collections.emptyList(), Lists.newArrayList(UserLikeTag.PET), Lists.newArrayList(1256L)),
    公众号_汽车(PostSourceType.GONGZHONGHAO, "汽车", Collections.emptyList(), Lists.newArrayList(UserLikeTag.CAR), Lists.newArrayList(1150L)),
    公众号_家居(PostSourceType.GONGZHONGHAO, "家居", Collections.emptyList(), Lists.newArrayList(UserLikeTag.LIFE), Lists.newArrayList(1264L)),
    公众号_动漫(PostSourceType.GONGZHONGHAO, "动漫", Collections.emptyList(), Lists.newArrayList(UserLikeTag.ANIME), Collections.emptyList()),
    公众号_健康养生(PostSourceType.GONGZHONGHAO, "健康养生", Lists.newArrayList(PostChannel.HEALTH), Lists.newArrayList(UserLikeTag.HEALTH), Lists.newArrayList(1261L)),
    公众号_社会(PostSourceType.GONGZHONGHAO, "社会", Lists.newArrayList(PostChannel.HOT), Lists.newArrayList(UserLikeTag.SOCIETY), Lists.newArrayList(1244L)),
    公众号_时事(PostSourceType.GONGZHONGHAO, "时事", Collections.emptyList(), Lists.newArrayList(UserLikeTag.SOCIETY), Lists.newArrayList(1233L)),
    公众号_军事(PostSourceType.GONGZHONGHAO, "军事", Collections.emptyList(), Lists.newArrayList(UserLikeTag.MILITARY), Lists.newArrayList(1334L)),
    公众号_游戏(PostSourceType.GONGZHONGHAO, "游戏", Collections.emptyList(), Lists.newArrayList(UserLikeTag.GAME), Collections.emptyList()),
    公众号_旅游(PostSourceType.GONGZHONGHAO, "旅游", Collections.emptyList(), Lists.newArrayList(UserLikeTag.TOURISM), Collections.emptyList()),
    公众号_国际(PostSourceType.GONGZHONGHAO, "国际", Collections.emptyList(), Lists.newArrayList(UserLikeTag.SOCIETY), Lists.newArrayList(1001L)),
    公众号_文化(PostSourceType.GONGZHONGHAO, "文化", Collections.emptyList(), Lists.newArrayList(UserLikeTag.CULTURE), Lists.newArrayList(1247L)),
    公众号_历史(PostSourceType.GONGZHONGHAO, "历史", Collections.emptyList(), Lists.newArrayList(UserLikeTag.HISTORY), Lists.newArrayList(1347L)),
    公众号_时尚(PostSourceType.GONGZHONGHAO, "时尚", Collections.emptyList(), Lists.newArrayList(UserLikeTag.FASHION), Lists.newArrayList(1169L)),
    公众号_旅行(PostSourceType.GONGZHONGHAO, "旅行", Collections.emptyList(), Collections.emptyList(), Lists.newArrayList(1237L)),
    公众号_音乐(PostSourceType.GONGZHONGHAO, "音乐", Collections.emptyList(), Lists.newArrayList(UserLikeTag.MUSIC), Lists.newArrayList(1235L)),
    公众号_母婴育儿(PostSourceType.GONGZHONGHAO, "母婴育儿", Collections.emptyList(), Lists.newArrayList(UserLikeTag.LIFE), Collections.emptyList()),
    公众号_娱乐(PostSourceType.GONGZHONGHAO, "娱乐", Collections.emptyList(), Lists.newArrayList(UserLikeTag.ENTERTAINMENT), Lists.newArrayList(1037L)),
    公众号_体育(PostSourceType.GONGZHONGHAO, "体育", Collections.emptyList(), Lists.newArrayList(UserLikeTag.SPORTS), Lists.newArrayList(1021L)),
    公众号_教育(PostSourceType.GONGZHONGHAO, "教育", Collections.emptyList(), Lists.newArrayList(UserLikeTag.EDUCATION), Lists.newArrayList(1073L)),
    公众号_手工(PostSourceType.GONGZHONGHAO, "手工", Collections.emptyList(), Collections.emptyList(), Lists.newArrayList(1078L)),
    公众号_情感(PostSourceType.GONGZHONGHAO, "情感", Lists.newArrayList(PostChannel.EMOTION), Lists.newArrayList(UserLikeTag.EMOTION), Lists.newArrayList(1331L)),
    公众号_星座运势(PostSourceType.GONGZHONGHAO, "星座运势", Collections.emptyList(), Lists.newArrayList(UserLikeTag.FORTUNE), Collections.emptyList()),
    公众号_财经(PostSourceType.GONGZHONGHAO, "财经", Collections.emptyList(), Lists.newArrayList(UserLikeTag.FINANCE), Lists.newArrayList(1243L)),
    公众号_搞笑(PostSourceType.GONGZHONGHAO, "搞笑", Lists.newArrayList(PostChannel.FUNNY), Lists.newArrayList(UserLikeTag.FUNNY), Lists.newArrayList(1260L)),
    腾讯视频_民生(PostSourceType.TX_XINWEN_SHEHUI, "shehui", Lists.newArrayList(PostChannel.HOT),
            Lists.newArrayList(UserLikeTag.SOCIETY), Collections.emptyList()),
    腾讯视频24小时_民生(PostSourceType.TX_XINWEN_NEWS_24, "0", Lists.newArrayList(PostChannel.HOT), Lists.newArrayList(UserLikeTag.SOCIETY), Collections.emptyList()),

    ;

    private static final HashBasedTable<PostSourceType, String, PostContentType> CACHE = HashBasedTable.create();

    static {
        Arrays.stream(PostContentType.values()).forEach(p -> CACHE.put(p.getSourceType(), p.getContentTypeId(), p));
    }

    private PostSourceType sourceType;

    private String contentTypeId;

    private List<PostChannel> channels;

    private List<UserLikeTag> tags;

    private List<Long> publishUsers;

    public static PostContentType of(PostSourceType sourceType, String contentTypeId) {
        return CACHE.get(sourceType, contentTypeId);
    }

    PostContentType(PostSourceType sourceType, String contentTypeId, List<PostChannel> channels,
                    List<UserLikeTag> tags, List<Long> publishUsers) {
        this.sourceType = sourceType;
        this.contentTypeId = contentTypeId;
        this.channels = channels;
        this.tags = tags;
        this.publishUsers = publishUsers;
    }

    public PostSourceType getSourceType() {
        return sourceType;
    }

    public String getContentTypeId() {
        return contentTypeId;
    }

    public List<UserLikeTag> getTags() {
        return tags;
    }

    public List<PostChannel> getChannels() {
        return channels;
    }

    public List<Long> getPublishUsers() {
        return publishUsers;
    }}
