package cn.tuia.explore.center.api.dto.req;

import java.io.Serializable;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: ReplyReqDto.java , v 0.1 2019-05-24 15:40 ElinZhou Exp $
 */
public class ReplyReqDto implements Serializable {
    private static final long serialVersionUID = -6803154566407171993L;

    /**
     * 评论id
     */
    private Long commentId;
    /**
     * 用户id
     */
    private Long userId;

    /**
     * 回复类型
     *
     * @see cn.tuia.explore.center.api.enums.LikeType
     */
    private Integer replyType;

    /**
     * 主贴的id
     */
    private Long postId;

    /**
     * 回复对象的id
     * 如果对帖子回复，使用帖子的id
     * 如果对评论回复，则使用评论的id
     */
    private Long targetId;

    /**
     * 语音评论地址
     */
    private String voiceContentUrl;

    /**
     * 评论文本内容
     */
    private String content;

    /**
     * 是否转发到我的动态
     */
    private boolean reprint;

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Integer getReplyType() {
        return replyType;
    }

    public void setReplyType(Integer replyType) {
        this.replyType = replyType;
    }

    public Long getPostId() {
        return postId;
    }

    public void setPostId(Long postId) {
        this.postId = postId;
    }

    public Long getTargetId() {
        return targetId;
    }

    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }

    public String getVoiceContentUrl() {
        return voiceContentUrl;
    }

    public void setVoiceContentUrl(String voiceContentUrl) {
        this.voiceContentUrl = voiceContentUrl;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Long getCommentId() {
        return commentId;
    }

    public void setCommentId(Long commentId) {
        this.commentId = commentId;
    }

    public boolean isReprint() {
        return reprint;
    }

    public void setReprint(boolean reprint) {
        this.reprint = reprint;
    }
}
