package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: PostChannel.java , v 0.1 2019-07-14 15:40 ElinZhou Exp $
 */
public enum PostChannel {

    POST_HOT("社会", 1, PostGroup.ARTICLE),
    POST_HEALTH("健康", 2, PostGroup.ARTICLE),
    POST_EMOTION("情感", 3, PostGroup.ARTICLE),
    POST_FUNNY("搞笑", 4, PostGroup.ARTICLE),

    VIDEO_FUNNY("搞笑", 5, PostGroup.VIDEO),
    VIDEO_MOVIE("影视", 6, PostGroup.VIDEO),
    VIDEO_VARIETY("综艺", 7, PostGroup.VIDEO),
    VIDEO_FOOD("美食", 8, PostGroup.VIDEO),
    VIDEO_SQUARE_DANCE("广场舞", 9, PostGroup.VIDEO),
//    VIDEO_SOCIETY("社会", 10, PostGroup.VIDEO),
    VIDEO_NBA("NBA", 11, PostGroup.VIDEO),
    VIDEO_PET("宠物", 12, PostGroup.VIDEO),
    VIDEO_SPORT("体育", 13, PostGroup.VIDEO),
    VIDEO_ENTERTAINMENT("娱乐", 14, PostGroup.VIDEO),
    VIDEO_CULTURE("文化", 15, PostGroup.VIDEO),
    VIDEO_MUSIC("音乐", 16, PostGroup.VIDEO),
    VIDEO_FASHION("时尚", 17, PostGroup.VIDEO),
    VIDEO_MANUAL("手工", 18, PostGroup.VIDEO),
    VIDEO_TECHNOLOGY("科技", 19, PostGroup.VIDEO),
    VIDEO_PARENT_CHILD("亲子", 20, PostGroup.VIDEO),
    VIDEO_VLOG("VLOG", 21, PostGroup.VIDEO),
    VIDEO_FARMER("农人", 22, PostGroup.VIDEO),
    ;


    private static final Map<Integer, PostChannel> CACHE =
            Arrays.stream(PostChannel.values()).collect(Collectors.toMap(PostChannel::getCode, p -> p));

    PostChannel(String title, int code, PostGroup group) {
        this.title = title;
        this.code = code;
        this.group = group;
    }

    private String title;
    private int code;

    private PostGroup group;

    public String getTitle() {
        return title;
    }

    public int getCode() {
        return code;
    }

    public PostGroup getGroup() {
        return group;
    }

    public static PostChannel of(Integer code) {
        return CACHE.get(code);
    }

    public static List<PostChannel> getChannels(PostGroup group) {
        return Arrays.stream(PostChannel.values()).filter(p -> p.getGroup() == group).sorted(Comparator.comparingInt(PostChannel::getCode)).collect(Collectors.toList());
    }


}
