package cn.tuia.explore.center.api.dto.general;

import cn.tuia.explore.center.api.dto.rsp.MessageDto;

import java.io.Serializable;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: AbstractMessageContent.java , v 0.1 2019-05-29 09:28 ElinZhou Exp $
 */
public abstract class AbstractMessageContent implements Serializable {
    private static final long serialVersionUID = 3696783090209160212L;

    protected abstract String title();

    protected abstract String content();

    protected abstract String icon();

    protected Long userId() {
        return null;
    }

    public String jumpPath() {
        return null;
    }

    public String jumpParams() {
        return null;
    }

    public MessageDto toMessage() {
        return new MessageDto(title(), content(), icon(), jumpPath(), jumpParams(), userId());
    }

}
