package cn.tuia.explore.center.api.dto.req;

import cn.tuia.explore.center.api.enums.PostFlowFetchType;

import java.io.Serializable;
import java.util.Date;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: PostFlowReqDto.java , v 0.1 2019-05-23 18:52 ElinZhou Exp $
 */
public class PostFlowReqDto extends AppWeakUserBaseReqDto {
    private static final long serialVersionUID = -5691273346474526469L;

    /**
     * 调用场景
     */
    private PostFlowFetchType scene;

    /**
     * 操作类型 1.下拉刷新 2.上拉加载更多
     */
    private int operator;

    /**
     * 目标用户的id
     */
    private Long targetUserId;

    /**
     * 圈子id
     */
    private Long groupId;
    /**
     * 需要获取内容的数量
     */
    private int count = 10;


    /**
     * 最旧的内容的发布时间
     */
    private Date referenceTime;

    /**
     * 频道id
     */
    private Integer channel;


    public PostFlowFetchType getScene() {
        return scene;
    }

    public void setScene(PostFlowFetchType scene) {
        this.scene = scene;
    }

    public int getOperator() {
        return operator;
    }

    public void setOperator(int operator) {
        this.operator = operator;
    }

    public Long getTargetUserId() {
        return targetUserId;
    }

    public void setTargetUserId(Long targetUserId) {
        this.targetUserId = targetUserId;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Date getReferenceTime() {
        return referenceTime;
    }

    public void setReferenceTime(Date referenceTime) {
        this.referenceTime = referenceTime;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public Integer getChannel() {
        return channel;
    }

    public void setChannel(Integer channel) {
        this.channel = channel;
    }
}
