package cn.tuia.explore.center.api.dto.rsp;

import java.io.Serializable;
import java.util.List;

@SuppressWarnings("squid:S1948")
public class PageQueryResultDto<T> implements Serializable {

    private static final long serialVersionUID = 9217161766995240259L;
    /**
     * 总记录数
     */
    private long total;

    /**
     * 记录列表
     */
    private List<T> list;

    public static <T> PageQueryResultDto<T> of(long total, List<T> list) {
        return new PageQueryResultDto<>(total, list);
    }

    public static <T> PageQueryResultDto<T> of(int total, List<T> list) {
        return new PageQueryResultDto<>((long) total, list);
    }

    public PageQueryResultDto(Long total, List<T> list) {
        this.total = total;
        this.list = list;
    }

    public PageQueryResultDto() {
    }

    public Long getTotal() {
        return total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public List<T> getList() {
        return list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }
}
