package cn.tuia.explore.center.api.enums;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: PostContentType.java , v 0.1 2019-07-14 16:01 ElinZhou Exp $
 */
@SuppressWarnings("squid:S00115")
public enum PostContentType {

    西瓜视频_宠物(PostSourceType.XIGUASHIPIN, "6141508406", Lists.newArrayList(PostChannel.VIDEO_PET), Lists.newArrayList(UserLikeTag.PET)),
    西瓜视频_农人(PostSourceType.XIGUASHIPIN, "61887739390", Lists.newArrayList(PostChannel.VIDEO_FARMER), Lists.newArrayList(UserLikeTag.SOCIETY)),
    西瓜视频_懂车帝(PostSourceType.XIGUASHIPIN, "7005980951", Collections.emptyList(), Lists.newArrayList(UserLikeTag.CAR)),
    西瓜视频_娱乐(PostSourceType.XIGUASHIPIN, "61887739374", Lists.newArrayList(PostChannel.VIDEO_ENTERTAINMENT), Lists.newArrayList(UserLikeTag.ENTERTAINMENT)),
    西瓜视频_影视(PostSourceType.XIGUASHIPIN, "61887739373", Lists.newArrayList(PostChannel.VIDEO_MOVIE), Collections.emptyList()),
    西瓜视频_时尚(PostSourceType.XIGUASHIPIN, "6141508390", Lists.newArrayList(PostChannel.VIDEO_FASHION), Lists.newArrayList(UserLikeTag.FASHION)),
    西瓜视频_游戏(PostSourceType.XIGUASHIPIN, "61887739376", Collections.emptyList(), Lists.newArrayList(UserLikeTag.GAME)),
    西瓜视频_手工(PostSourceType.XIGUASHIPIN, "94349531488", Lists.newArrayList(PostChannel.VIDEO_MANUAL), Lists.newArrayList(UserLikeTag.LIFE)),
    西瓜视频_综艺(PostSourceType.XIGUASHIPIN, "61887739345", Lists.newArrayList(PostChannel.VIDEO_VARIETY), Lists.newArrayList(UserLikeTag.ENTERTAINMENT)),
    西瓜视频_美食(PostSourceType.XIGUASHIPIN, "6141508391", Lists.newArrayList(PostChannel.VIDEO_FOOD), Lists.newArrayList(UserLikeTag.FOOD)),
    西瓜视频_广场舞(PostSourceType.XIGUASHIPIN, "61887739388", Lists.newArrayList(PostChannel.VIDEO_SQUARE_DANCE), Lists.newArrayList(UserLikeTag.SOCIETY)),
    西瓜视频_亲子(PostSourceType.XIGUASHIPIN, "61887739344", Lists.newArrayList(PostChannel.VIDEO_PARENT_CHILD), Lists.newArrayList(UserLikeTag.PARENT_CHILD)),
    西瓜视频_搞笑(PostSourceType.XIGUASHIPIN, "61887739369", Lists.newArrayList(PostChannel.VIDEO_FUNNY), Lists.newArrayList(UserLikeTag.FUNNY)),
    西瓜视频_音乐(PostSourceType.XIGUASHIPIN, "61887739368", Lists.newArrayList(PostChannel.VIDEO_MUSIC), Lists.newArrayList(UserLikeTag.MUSIC)),
    西瓜视频_文化(PostSourceType.XIGUASHIPIN, "6141508399", Lists.newArrayList(PostChannel.VIDEO_CULTURE), Lists.newArrayList(UserLikeTag.CULTURE)),
    西瓜视频_体育(PostSourceType.XIGUASHIPIN, "5798809184", Lists.newArrayList(PostChannel.VIDEO_SPORT), Lists.newArrayList(UserLikeTag.SPORTS)),
    西瓜视频_科技(PostSourceType.XIGUASHIPIN, "6141508396", Lists.newArrayList(PostChannel.VIDEO_TECHNOLOGY), Lists.newArrayList(UserLikeTag.TECHNOLOGY)),
    西瓜视频_儿童(PostSourceType.XIGUASHIPIN, "6141508395", Collections.emptyList(), Lists.newArrayList(UserLikeTag.PARENT_CHILD)),
    西瓜视频_NBA(PostSourceType.XIGUASHIPIN, "94349530916", Lists.newArrayList(PostChannel.VIDEO_NBA), Lists.newArrayList(UserLikeTag.SPORTS)),
    西瓜视频_VLOG(PostSourceType.XIGUASHIPIN, "94349533351", Lists.newArrayList(PostChannel.VIDEO_VLOG), Lists.newArrayList(UserLikeTag.LIFE)),
    头条摄影集_0(PostSourceType.TOUTIAOSHEYING, "0",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.PHOTOGRAPHY)),
    跳吧广场舞_0(PostSourceType.TIAO_BA, "0",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.SQUARE_DANCE)),
    皮皮虾_0(PostSourceType.PIPIXIA, "0",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.FUNNY)),
    新浪图片_0(PostSourceType.XINLANGTUPIAN, "0",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.PHOTOGRAPHY)),
    梨视频_社会(PostSourceType.LISHIPIN, "1", Lists.newArrayList(PostChannel.POST_HOT), Lists.newArrayList(UserLikeTag.SOCIETY)),
    梨视频_实结(PostSourceType.LISHIPIN, "2",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.SOCIETY)),
    梨视频_财富(PostSourceType.LISHIPIN, "3",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.FINANCE)),
    梨视频_娱乐(PostSourceType.LISHIPIN, "4",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.ENTERTAINMENT)),
    梨视频_音乐(PostSourceType.LISHIPIN, "59",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.MUSIC)),
    梨视频_生活(PostSourceType.LISHIPIN, "5",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.LIFE)),
    梨视频_美食(PostSourceType.LISHIPIN, "6",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.FOOD)),
    梨视频_科技(PostSourceType.LISHIPIN, "8",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.TECHNOLOGY)),
    梨视频_体育(PostSourceType.LISHIPIN, "9",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.SPORTS)),
    梨视频_汽车(PostSourceType.LISHIPIN, "31",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.CAR)),
    梨视频_新知(PostSourceType.LISHIPIN, "10",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.SOCIETY)),
    美篇_影视(PostSourceType.MEIPIAN, "TV",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.ENTERTAINMENT)),
    美篇_情感(PostSourceType.MEIPIAN, "emotion",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.EMOTION)),
    美篇_女神(PostSourceType.MEIPIAN, "beauty",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.PHOTOGRAPHY)),
    美篇_美文(PostSourceType.MEIPIAN, "fiction",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.LIFE)),
    美篇_摄影(PostSourceType.MEIPIAN, "photo",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.PHOTOGRAPHY)),
    美篇_生活(PostSourceType.MEIPIAN, "life",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.LIFE)),
    美篇_旅行(PostSourceType.MEIPIAN, "tour",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.TOURISM)),
    美篇_美食(PostSourceType.MEIPIAN, "food",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.FOOD)),
    美篇_兴趣(PostSourceType.MEIPIAN, "hobby",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.LIFE)),
    公众号_科技(PostSourceType.GONGZHONGHAO, "科技",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.TECHNOLOGY)),
    公众号_美食(PostSourceType.GONGZHONGHAO, "美食",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.FOOD)),
    公众号_宠物(PostSourceType.GONGZHONGHAO, "宠物",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.PET)),
    公众号_汽车(PostSourceType.GONGZHONGHAO, "汽车",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.CAR)),
    公众号_家居(PostSourceType.GONGZHONGHAO, "家居",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.LIFE)),
    公众号_动漫(PostSourceType.GONGZHONGHAO, "动漫",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.ANIME)),
    公众号_健康养生(PostSourceType.GONGZHONGHAO, "健康养生", Lists.newArrayList(PostChannel.POST_HEALTH), Lists.newArrayList(UserLikeTag.HEALTH)),
    公众号_社会(PostSourceType.GONGZHONGHAO, "社会", Lists.newArrayList(PostChannel.POST_HOT), Lists.newArrayList(UserLikeTag.SOCIETY)),
    公众号_时事(PostSourceType.GONGZHONGHAO, "时事",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.SOCIETY)),
    公众号_军事(PostSourceType.GONGZHONGHAO, "军事",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.MILITARY)),
    公众号_游戏(PostSourceType.GONGZHONGHAO, "游戏",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.GAME)),
    公众号_旅游(PostSourceType.GONGZHONGHAO, "旅游",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.TOURISM)),
    公众号_国际(PostSourceType.GONGZHONGHAO, "国际",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.SOCIETY)),
    公众号_文化(PostSourceType.GONGZHONGHAO, "文化",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.CULTURE)),
    公众号_历史(PostSourceType.GONGZHONGHAO, "历史",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.HISTORY)),
    公众号_时尚(PostSourceType.GONGZHONGHAO, "时尚",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.FASHION)),
    公众号_旅行(PostSourceType.GONGZHONGHAO, "旅行",Collections.emptyList(),  Collections.emptyList()),
    公众号_音乐(PostSourceType.GONGZHONGHAO, "音乐",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.MUSIC)),
    公众号_母婴育儿(PostSourceType.GONGZHONGHAO, "母婴育儿",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.LIFE)),
    公众号_娱乐(PostSourceType.GONGZHONGHAO, "娱乐",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.ENTERTAINMENT)),
    公众号_体育(PostSourceType.GONGZHONGHAO, "体育",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.SPORTS)),
    公众号_教育(PostSourceType.GONGZHONGHAO, "教育",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.EDUCATION)),
    公众号_手工(PostSourceType.GONGZHONGHAO, "手工",Collections.emptyList(),  Collections.emptyList()),
    公众号_情感(PostSourceType.GONGZHONGHAO, "情感", Lists.newArrayList(PostChannel.POST_EMOTION), Lists.newArrayList(UserLikeTag.EMOTION)),
    公众号_星座运势(PostSourceType.GONGZHONGHAO, "星座运势",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.FORTUNE)),
    公众号_财经(PostSourceType.GONGZHONGHAO, "财经",Collections.emptyList(),  Lists.newArrayList(UserLikeTag.FINANCE)),
    公众号_搞笑(PostSourceType.GONGZHONGHAO, "搞笑", Lists.newArrayList(PostChannel.POST_FUNNY), Lists.newArrayList(UserLikeTag.FUNNY)),
    腾讯视频_民生(PostSourceType.TX_XINWEN_SHEHUI, "shehui", Lists.newArrayList(PostChannel.POST_HOT), Lists.newArrayList(UserLikeTag.SOCIETY)),
    腾讯视频24小时_民生(PostSourceType.TX_XINWEN_NEWS_24, "0", Lists.newArrayList(PostChannel.POST_HOT), Lists.newArrayList(UserLikeTag.SOCIETY)),
    人民网_科技(PostSourceType.REN_MIN_WANG, "1", Lists.newArrayList(PostChannel.POST_TECHNOLOGY), Lists.newArrayList(UserLikeTag.TECHNOLOGY)),
    人民网_美食(PostSourceType.REN_MIN_WANG, "2", Lists.newArrayList(PostChannel.POST_FOOD), Lists.newArrayList(UserLikeTag.FOOD)),
    人民网_汽车(PostSourceType.REN_MIN_WANG, "3", Lists.newArrayList(PostChannel.POST_CAR), Lists.newArrayList(UserLikeTag.CAR)),
    人民网_历史(PostSourceType.REN_MIN_WANG, "4", Lists.newArrayList(PostChannel.POST_HISTORY), Lists.newArrayList(UserLikeTag.HISTORY)),
    人民网_时尚(PostSourceType.REN_MIN_WANG, "5", Lists.newArrayList(PostChannel.POST_FASHION), Lists.newArrayList(UserLikeTag.FASHION)),
    人民网_要闻(PostSourceType.REN_MIN_WANG, "6", Lists.newArrayList(PostChannel.POST_NEWS), Collections.emptyList()),
    人民网_探索(PostSourceType.REN_MIN_WANG, "7", Lists.newArrayList(PostChannel.POST_EXPLORE), Collections.emptyList()),
    人民网_社会(PostSourceType.REN_MIN_WANG, "8", Lists.newArrayList(PostChannel.POST_HOT), Lists.newArrayList(UserLikeTag.SOCIETY)),
    人民网_娱乐(PostSourceType.REN_MIN_WANG, "9", Lists.newArrayList(PostChannel.POST_ENTERTAINMENT), Lists.newArrayList(UserLikeTag.ENTERTAINMENT)),
    人民网_体育(PostSourceType.REN_MIN_WANG, "10", Lists.newArrayList(PostChannel.POST_SPORT), Lists.newArrayList(UserLikeTag.SPORTS)),
    人民网_教育(PostSourceType.REN_MIN_WANG, "11", Lists.newArrayList(PostChannel.POST_EDUCATION), Lists.newArrayList(UserLikeTag.EDUCATION)),
    人民网_健康(PostSourceType.REN_MIN_WANG, "12", Lists.newArrayList(PostChannel.POST_HEALTH), Lists.newArrayList(UserLikeTag.HEALTH)),
    人民网_军事(PostSourceType.REN_MIN_WANG, "13", Lists.newArrayList(PostChannel.POST_MILITARY), Lists.newArrayList(UserLikeTag.MILITARY)),
    人民网_财经(PostSourceType.REN_MIN_WANG, "14", Lists.newArrayList(PostChannel.POST_FINANCE), Lists.newArrayList(UserLikeTag.FINANCE)),
    人民网_旅游(PostSourceType.REN_MIN_WANG, "15", Lists.newArrayList(PostChannel.POST_TOURISM), Lists.newArrayList(UserLikeTag.TOURISM)),

    ;

    private static final HashBasedTable<PostSourceType, String, PostContentType> CACHE = HashBasedTable.create();

    static {
        Arrays.stream(PostContentType.values()).forEach(p -> CACHE.put(p.getSourceType(), p.getContentTypeId(), p));
    }

    private PostSourceType sourceType;

    private String contentTypeId;

    private List<PostChannel> channels;

    private List<UserLikeTag> tags;

    public static PostContentType of(PostSourceType sourceType, String contentTypeId) {
        return CACHE.get(sourceType, contentTypeId);
    }

    PostContentType(PostSourceType sourceType, String contentTypeId, List<PostChannel> channels,
                    List<UserLikeTag> tags) {
        this.sourceType = sourceType;
        this.contentTypeId = contentTypeId;
        this.channels = channels;
        this.tags = tags;
    }

    public PostSourceType getSourceType() {
        return sourceType;
    }

    public String getContentTypeId() {
        return contentTypeId;
    }

    public List<UserLikeTag> getTags() {
        return tags;
    }

    public List<PostChannel> getChannels() {
        return channels;
    }
}
