package cn.tuia.explore.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.explore.center.api.dto.req.CommentDeleteDto;
import cn.tuia.explore.center.api.dto.req.ReplyPageReqDto;
import cn.tuia.explore.center.api.dto.req.ReplyReqDto;
import cn.tuia.explore.center.api.dto.rsp.PageQueryResultDto;
import cn.tuia.explore.center.api.dto.rsp.ReplyDto;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: RemoteCommentService.java , v 0.1 2019-05-29 18:36 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteCommentService {

    /**
     * 评论
     *
     * @param replyReqDto
     */
    long reply(ReplyReqDto replyReqDto) throws BizException;

    /**
     * 查询某条内容下的评论
     *
     * @param replyPageReqDto
     * @return
     * @throws BizException
     */
    PageQueryResultDto<ReplyDto> pageQuery(ReplyPageReqDto replyPageReqDto) throws BizException;

    /**
     * 删除评论
     *
     * @param deleteDto
     * @return
     * @throws BizException
     */
    boolean delete(CommentDeleteDto deleteDto) throws BizException;


}
