package cn.tuia.explore.center.api.dto.general;

import com.alibaba.fastjson.JSON;

import java.util.Collections;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: ReplyRecommendPostMessage.java , v 0.1 2019-05-29 09:32 ElinZhou Exp $
 */
public class ReplyRecommendPostMessage extends AbstractMessageContent {
    private static final long serialVersionUID = 3712072417707823637L;

    private static final transient String TEMPLATE = "%s评论了你推荐的文章";

    private long replyUserId;

    private long commentId;

    private long postId;

    private transient String nickName;

    private transient String headImage;

    private transient String content;

    public ReplyRecommendPostMessage() {
    }

    public ReplyRecommendPostMessage(long replyUserId, long commentId, long postId) {
        this.replyUserId = replyUserId;
        this.commentId = commentId;
        this.postId = postId;
    }

    @Override
    public String jumpPath() {
        return "/content/detail";
    }

    @Override
    public String jumpParams() {
        return JSON.toJSONString(Collections.singletonMap("unionId", postId));
    }

    @Override
    protected Long userId() {
        return replyUserId;
    }

    @Override
    public String title() {
        return String.format(TEMPLATE, nickName);
    }

    @Override
    public String content() {
        return content;
    }

    @Override
    public String icon() {
        return headImage;
    }

    public long getReplyUserId() {
        return replyUserId;
    }

    public void setReplyUserId(long replyUserId) {
        this.replyUserId = replyUserId;
    }

    public long getCommentId() {
        return commentId;
    }

    public void setCommentId(long commentId) {
        this.commentId = commentId;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getHeadImage() {
        return headImage;
    }

    public void setHeadImage(String headImage) {
        this.headImage = headImage;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public long getPostId() {
        return postId;
    }

    public void setPostId(long postId) {
        this.postId = postId;
    }
}
