package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ElinZhou eeelinzhou@gmail.com
 * @version $Id: Achievement.java , v 0.1 2019-08-13 09:55 ElinZhou Exp $
 */
public enum Achievement {

    ZERO(1, 0, 0, 0),
    ONE(2, 1, 1, 1),
    TWO(3, 10, 5, 5),
    THREE(4, 30, 15, 15),
    FOUR(5, 60, 30, 30),
    FIVE(6, 100, 50, 50),
    SIX(7, 150, 75, 75),
    SEVEN(8, 200, 100, 100),
    EIGHT(9, 300, 150, 150),
    NINE(10, 400, 200, 200),
    TEN(11, 500, 250, 250),
    ELEVEN(12, 700, 350, 350),
    TWELVE(13, 900, 450, 450),
    THIRTEEN(14, 1200, 600, 600),
    FOURTEEN(15, 1500, 750, 750),
    FIFTEEN(16, 1800, 900, 900),

    INFINITE(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE),
    ;


    private int level;

    private long read;

    private long comment;

    private long share;

    private static final List<Achievement> LIST =
            Arrays.stream(Achievement.values()).sorted(Comparator.comparingInt(Achievement::getLevel)).collect(Collectors.toList());

    private static final Map<Integer, Achievement> CACHE =
            LIST.stream().collect(Collectors.toMap(Achievement::getLevel, a -> a));

    Achievement(int level, long read, long comment, long share) {
        this.level = level;
        this.read = read;
        this.comment = comment;
        this.share = share;
    }

    public int getLevel() {
        return level;
    }

    public long getRead() {
        return read;
    }

    public long getComment() {
        return comment;
    }

    public long getShare() {
        return share;
    }

    public static Achievement of(int level) {
        Achievement achievement = CACHE.get(level);
        if (achievement != null) {
            return achievement;
        }
        return ZERO;
    }

    public static Achievement level(UserAchievementType type, long process) {

        if (type == UserAchievementType.READ) {
            process /= 60;
        }
        for (Achievement achievement : LIST) {
            if (process < getGoal(type, achievement)) {
                return of(achievement.getLevel() - 1);
            }
        }
        return ZERO;
    }

    private static long getGoal(UserAchievementType type, Achievement achievement) {
        if (type == UserAchievementType.READ) {
            return achievement.getRead();
        } else if (type == UserAchievementType.COMMENT) {
            return achievement.getComment();
        } else if (type == UserAchievementType.SHARE) {
            return achievement.getShare();
        }
        return 0;
    }
}
