package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 点赞类型
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: LikeType.java , v 0.1 2019/5/23 9:29 PM ZhouFeng Exp $
 */
public enum LikeType {

    /**
     * 帖子
     */
    POST(1),

    /**
     * 评论
     */
    COMMENT(2),

    /**
     * 讨论
     */
    DISCUSS(3),
    ;


    private static final Map<Integer, LikeType> CACHE =
            Arrays.stream(LikeType.values()).collect(Collectors.toMap(LikeType::getCode, p -> p));


    private int code;

    LikeType(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public static LikeType of(Integer code) {
        return CACHE.get(code);
    }
}
