package cn.tuia.explore.center.api.enums;

import com.google.common.collect.Lists;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ElinZhou eeelinzhou@gmail.com
 * @version $Id: ReadTaskType.java , v 0.1 2019-09-18 17:10 ElinZhou Exp $
 */
public enum ReadTaskType {

    NEWBIE(1, "新手班", 1, 5, 2.11, 10000, 0.75, 0.85
            , Lists.newArrayList(100)),
    PRIMARY(2, "初级班", 3, 15, 1.61, 5000, 0.65, 0.75
            , Lists.newArrayList(3, 27, 100)),
    MIDDLE(3, "中级班", 7, 15, 0.91, 15000, 0.6, 0.7
            , Lists.newArrayList(6, 13, 29, 56, 80, 92, 100)),
    SENIRO(4, "高级班", 21, 15, 0.21, 50000, 0.7, 0.9
            , Lists.newArrayList(6, 7, 8, 10, 12, 16, 21, 30, 38, 46, 59, 67, 74, 80, 85, 90, 93, 95, 97, 99, 100)),

    ;

    ReadTaskType(int level, String name, int durationDays, int minutes, double delta, long coinEachUser,
                 double successRateStart,
                 double successRateEnd, List<Integer> failureRate) {
        this.level = level;
        this.name = name;
        this.durationDays = durationDays;
        this.minutes = minutes;
        this.delta = delta;
        this.coinEachUser = coinEachUser;
        this.successRateStart = successRateStart;
        this.successRateEnd = successRateEnd;
        this.failureRate = failureRate;
    }

    private int level;

    private String name;

    private int durationDays;

    /**
     * 每日目标分钟数
     */
    private int minutes;

    /**
     * 假用户增长系数
     */
    private double delta;

    /**
     * 每个用户为奖池提供的金币数
     */
    private long coinEachUser;

    /**
     * 成功率随机起始
     */
    private double successRateStart;
    /**
     * 成功率随机截止
     */
    private double successRateEnd;

    private List<Integer> failureRate;

    private static final Map<Integer, ReadTaskType> CACHE =
            Arrays.stream(ReadTaskType.values()).collect(Collectors.toMap(ReadTaskType::getLevel, r -> r));

    public static ReadTaskType of(int level) {
        return CACHE.get(level);
    }

    public long getCoinEachUser() {
        return coinEachUser;
    }

    public double getSuccessRateStart() {
        return successRateStart;
    }

    public double getSuccessRateEnd() {
        return successRateEnd;
    }

    public int getLevel() {
        return level;
    }

    public String getName() {
        return name;
    }

    public int getDurationDays() {
        return durationDays;
    }

    public List<Integer> getFailureRate() {
        return failureRate;
    }

    public double getDelta() {
        return delta;
    }

    public int getMinutes() {
        return minutes;
    }}
