package cn.tuia.explore.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ElinZhou eeelinzhou@gmail.com
 * @version $Id: UserAchievementType.java , v 0.1 2019-08-12 14:52 ElinZhou Exp $
 */
public enum UserAchievementType {

    READ(1), COMMENT(2), SHARE(3),
    ;


    private int code;

    private static final Map<Integer, UserAchievementType> CACHE =
            Arrays.stream(UserAchievementType.values()).collect(Collectors.toMap(UserAchievementType::getCode, u -> u));

    UserAchievementType(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public static UserAchievementType of(int code) {
        return CACHE.get(code);
    }
}
